/*
Copyright 2024 Keyfactor

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

EJBCA REST Interface

API reference documentation.

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ejbca

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"os"
	"strings"
)

// V1CaApiService V1CaApi service
type V1CaApiService service

type ApiCreateCrlRequest struct {
	ctx        context.Context
	ApiService *V1CaApiService
	issuerDn   string
	deltacrl   *bool
}

// true to also create the deltaCRL, false to only create the base CRL
func (r ApiCreateCrlRequest) Deltacrl(deltacrl bool) ApiCreateCrlRequest {
	r.deltacrl = &deltacrl
	return r
}

func (r ApiCreateCrlRequest) Execute() (*CreateCrlRestResponse, *http.Response, error) {
	return r.ApiService.CreateCrlExecute(r)
}

/*
CreateCrl Create CRL(main, partition and delta) issued by this CA

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param issuerDn the CRL issuers DN (CAs subject DN)
	@return ApiCreateCrlRequest
*/
func (a *V1CaApiService) CreateCrl(ctx context.Context, issuerDn string) ApiCreateCrlRequest {
	return ApiCreateCrlRequest{
		ApiService: a,
		ctx:        ctx,
		issuerDn:   issuerDn,
	}
}

// Execute executes the request
//
//	@return CreateCrlRestResponse
func (a *V1CaApiService) CreateCrlExecute(r ApiCreateCrlRequest) (*CreateCrlRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodPost
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CreateCrlRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/ca/{issuer_dn}/createcrl"
	localVarPath = strings.Replace(localVarPath, "{"+"issuer_dn"+"}", url.PathEscape(parameterValueToString(r.issuerDn, "issuerDn")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.deltacrl != nil {
		parameterAddToQuery(localVarQueryParams, "deltacrl", r.deltacrl, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetCertificateAsPemRequest struct {
	ctx        context.Context
	ApiService *V1CaApiService
	subjectDn  string
}

func (r ApiGetCertificateAsPemRequest) Execute() (*http.Response, error) {
	return r.ApiService.GetCertificateAsPemExecute(r)
}

/*
GetCertificateAsPem Get PEM file with the active CA certificate chain

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param subjectDn CAs subject DN
	@return ApiGetCertificateAsPemRequest
*/
func (a *V1CaApiService) GetCertificateAsPem(ctx context.Context, subjectDn string) ApiGetCertificateAsPemRequest {
	return ApiGetCertificateAsPemRequest{
		ApiService: a,
		ctx:        ctx,
		subjectDn:  subjectDn,
	}
}

// Execute executes the request
func (a *V1CaApiService) GetCertificateAsPemExecute(r ApiGetCertificateAsPemRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod = http.MethodGet
		localVarPostBody   interface{}
		formFiles          []formFile
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/ca/{subject_dn}/certificate/download"
	localVarPath = strings.Replace(localVarPath, "{"+"subject_dn"+"}", url.PathEscape(parameterValueToString(r.subjectDn, "subjectDn")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetLatestCrlRequest struct {
	ctx               context.Context
	ApiService        *V1CaApiService
	issuerDn          string
	deltaCrl          *bool
	crlPartitionIndex *int32
}

// true to get the latest deltaCRL, false to get the latest complete CRL
func (r ApiGetLatestCrlRequest) DeltaCrl(deltaCrl bool) ApiGetLatestCrlRequest {
	r.deltaCrl = &deltaCrl
	return r
}

// the CRL partition index
func (r ApiGetLatestCrlRequest) CrlPartitionIndex(crlPartitionIndex int32) ApiGetLatestCrlRequest {
	r.crlPartitionIndex = &crlPartitionIndex
	return r
}

func (r ApiGetLatestCrlRequest) Execute() (*CrlRestResponse, *http.Response, error) {
	return r.ApiService.GetLatestCrlExecute(r)
}

/*
GetLatestCrl Returns the latest CRL issued by this CA

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param issuerDn the CRL issuers DN (CAs subject DN)
	@return ApiGetLatestCrlRequest
*/
func (a *V1CaApiService) GetLatestCrl(ctx context.Context, issuerDn string) ApiGetLatestCrlRequest {
	return ApiGetLatestCrlRequest{
		ApiService: a,
		ctx:        ctx,
		issuerDn:   issuerDn,
	}
}

// Execute executes the request
//
//	@return CrlRestResponse
func (a *V1CaApiService) GetLatestCrlExecute(r ApiGetLatestCrlRequest) (*CrlRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CrlRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/ca/{issuer_dn}/getLatestCrl"
	localVarPath = strings.Replace(localVarPath, "{"+"issuer_dn"+"}", url.PathEscape(parameterValueToString(r.issuerDn, "issuerDn")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.deltaCrl != nil {
		parameterAddToQuery(localVarQueryParams, "deltaCrl", r.deltaCrl, "")
	}
	if r.crlPartitionIndex != nil {
		parameterAddToQuery(localVarQueryParams, "crlPartitionIndex", r.crlPartitionIndex, "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiImportCrlRequest struct {
	ctx               context.Context
	ApiService        *V1CaApiService
	issuerDn          string
	crlFile           *os.File
	crlPartitionIndex *int32
}

// CRL file in DER format
func (r ApiImportCrlRequest) CrlFile(crlFile *os.File) ApiImportCrlRequest {
	r.crlFile = crlFile
	return r
}

// CRL partition index
func (r ApiImportCrlRequest) CrlPartitionIndex(crlPartitionIndex int32) ApiImportCrlRequest {
	r.crlPartitionIndex = &crlPartitionIndex
	return r
}

func (r ApiImportCrlRequest) Execute() (*http.Response, error) {
	return r.ApiService.ImportCrlExecute(r)
}

/*
ImportCrl Import a certificate revocation list (CRL) for a CA

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@param issuerDn the CRL issuers DN (CAs subject DN)
	@return ApiImportCrlRequest
*/
func (a *V1CaApiService) ImportCrl(ctx context.Context, issuerDn string) ApiImportCrlRequest {
	return ApiImportCrlRequest{
		ApiService: a,
		ctx:        ctx,
		issuerDn:   issuerDn,
	}
}

// Execute executes the request
func (a *V1CaApiService) ImportCrlExecute(r ApiImportCrlRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod = http.MethodPost
		localVarPostBody   interface{}
		formFiles          []formFile
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/ca/{issuer_dn}/importcrl"
	localVarPath = strings.Replace(localVarPath, "{"+"issuer_dn"+"}", url.PathEscape(parameterValueToString(r.issuerDn, "issuerDn")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	var crlFileLocalVarFormFileName string
	var crlFileLocalVarFileName string
	var crlFileLocalVarFileBytes []byte

	crlFileLocalVarFormFileName = "crlFile"

	crlFileLocalVarFile := r.crlFile

	if crlFileLocalVarFile != nil {
		fbs, _ := io.ReadAll(crlFileLocalVarFile)

		crlFileLocalVarFileBytes = fbs
		crlFileLocalVarFileName = crlFileLocalVarFile.Name()
		crlFileLocalVarFile.Close()
		formFiles = append(formFiles, formFile{fileBytes: crlFileLocalVarFileBytes, fileName: crlFileLocalVarFileName, formFileName: crlFileLocalVarFormFileName})
	}
	if r.crlPartitionIndex != nil {
		parameterAddToQuery(localVarFormParams, "crlPartitionIndex", r.crlPartitionIndex, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiListCasRequest struct {
	ctx        context.Context
	ApiService *V1CaApiService
}

func (r ApiListCasRequest) Execute() (*CaInfosRestResponse, *http.Response, error) {
	return r.ApiService.ListCasExecute(r)
}

/*
ListCas Returns the Response containing the list of CAs with general information per CA as Json

Returns the Response containing the list of CAs with general information per CA as Json

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiListCasRequest
*/
func (a *V1CaApiService) ListCas(ctx context.Context) ApiListCasRequest {
	return ApiListCasRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return CaInfosRestResponse
func (a *V1CaApiService) ListCasExecute(r ApiListCasRequest) (*CaInfosRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *CaInfosRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/ca"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiStatus1Request struct {
	ctx        context.Context
	ApiService *V1CaApiService
}

func (r ApiStatus1Request) Execute() (*RestResourceStatusRestResponse, *http.Response, error) {
	return r.ApiService.Status1Execute(r)
}

/*
Status1 Get the status of this REST Resource

Returns status, API version and EJBCA version.

	@param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	@return ApiStatus1Request
*/
func (a *V1CaApiService) Status1(ctx context.Context) ApiStatus1Request {
	return ApiStatus1Request{
		ApiService: a,
		ctx:        ctx,
	}
}

// Execute executes the request
//
//	@return RestResourceStatusRestResponse
func (a *V1CaApiService) Status1Execute(r ApiStatus1Request) (*RestResourceStatusRestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod  = http.MethodGet
		localVarPostBody    interface{}
		formFiles           []formFile
		localVarReturnValue *RestResourceStatusRestResponse
	)

	localBasePath := "/ejbca/ejbca-rest-api"

	localVarPath := localBasePath + "/v1/ca/status"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
