/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.DataProductsDAOSyb;
import org.eso.util.dal.NgasFileDAOSyb;
import org.eso.util.dal.Package;
import org.eso.util.dal.PackageAuxFilesDAOSyb;
import org.eso.util.dal.PackageFile;
import org.eso.util.dal.PackageFilesDAOSyb;
import org.eso.util.dal.PackageInfo;
import org.eso.util.dal.PackageInfoDAOSyb;
import org.eso.util.dal.PackageReport;
import org.eso.util.dal.PackageReportsDAOSyb;
import org.eso.util.dal.ServiceException;
import org.eso.util.dal.SybaseConnectionService;

public class PackageService {
    static final Logger logger = Logger.getLogger(PackageService.class);
    private static final String classLogName = "PackageService";
    private Integer MAX_TEXT_SIZE = 10000000;
    private boolean d_configured = false;
    private String d_dbUrl = null;
    private String d_dbUsername = null;
    private String d_dbPassword = null;
    private String d_dbInfoTable = null;
    private String d_dbReportsTable = null;
    private String d_dbFilesTable = null;
    private String d_dbObsDataProductsTable = null;
    private String d_dbCalibDataProductsTable = null;
    private String d_dbAuxFilesTable = null;
    private String d_dbNgasFilesTable = null;
    private String d_dbcmDbUrl = null;
    private String d_dbcmDbUserName = null;
    private String d_dbcmDbPassword = null;
    private String d_dbcmDbTrackingTable = null;
    private Map<String, Integer> d_specialPeriods = null;
    private String d_dbUniqueIdProcedure;

    public PackageService(String dbUrl, String dbUsername, String dbPassword, String dbcmDbUrl, String dbcmDbUserName, String dbcmDbPassword) {
        this.d_dbUrl = dbUrl;
        this.d_dbUsername = dbUsername;
        this.d_dbPassword = dbPassword;
        this.d_dbcmDbUrl = dbcmDbUrl;
        this.d_dbcmDbUserName = dbcmDbUserName;
        this.d_dbcmDbPassword = dbcmDbPassword;
    }

    public void configureTables(String dbInfoTable, String dbReportsTable, String dbFilesTable, String dbObsDataProductsTable, String dbCalibDataProductsTable, String dbAuxFilesTable, String dbNgasFilesTable, String dbcmDbTrackingTable, String dbUniqueIdProcedure) {
        this.d_dbInfoTable = dbInfoTable;
        this.d_dbFilesTable = dbFilesTable;
        this.d_dbReportsTable = dbReportsTable;
        this.d_dbObsDataProductsTable = dbObsDataProductsTable;
        this.d_dbCalibDataProductsTable = dbCalibDataProductsTable;
        this.d_dbAuxFilesTable = dbAuxFilesTable;
        this.d_dbNgasFilesTable = dbNgasFilesTable;
        this.d_dbcmDbTrackingTable = dbcmDbTrackingTable;
        this.d_dbUniqueIdProcedure = dbUniqueIdProcedure;
        this.d_configured = true;
    }

    public String fileIdFromFilename(String filename) throws ServiceException {
        String thisMethod = "PackageService::fileIdFromFilename()";
        logger.trace("PackageService::fileIdFromFilename()");
        DataProductsDAOSyb obsDao = new DataProductsDAOSyb(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword, this.d_dbObsDataProductsTable);
        DataProductsDAOSyb calibDao = new DataProductsDAOSyb(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword, this.d_dbCalibDataProductsTable);
        try {
            logger.debug("PackageService::fileIdFromFilename() - looking for file id of file [" + filename + "]");
            String filenameNoExt = filename.replace(".fits", "");
            if (obsDao.findDpId(filenameNoExt)) {
                return filenameNoExt;
            }
            return calibDao.getDpId(filename);
        }
        catch (DAOException e2) {
            throw new ServiceException(e2.getMessage());
        }
    }

    public Integer getPackageId(String runId, String instrument) throws ServiceException {
        String thisMethod = "PackageService::fileIdFromFilename()";
        logger.trace("PackageService::fileIdFromFilename()");
        Integer res = null;
        Connection conn = null;
        try {
            conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
        }
        catch (ConnectionServiceException e2) {
            throw new ServiceException(e2.getMessage());
        }
        try {
            PackageInfoDAOSyb pkgInfoDAO = new PackageInfoDAOSyb(conn, this.d_dbInfoTable, this.d_dbUniqueIdProcedure);
            res = pkgInfoDAO.getPackageId(runId, instrument);
        }
        catch (DAOException e3) {
            throw new ServiceException(e3.getMessage());
        }
        finally {
            try {
                SybaseConnectionService.closeConnection(conn);
            }
            catch (ConnectionServiceException ex) {
                logger.error("PackageService::fileIdFromFilename() - " + ex.getMessage());
                throw new ServiceException(ex.getMessage());
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPackage(Package pkg) throws ServiceException {
        block28: {
            String thisMethod = "PackageService::insertPackage()";
            logger.trace("PackageService::insertPackage()");
            Connection conn = null;
            String message = null;
            try {
                conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                SybaseConnectionService.executeStatement(conn, "set textsize " + this.MAX_TEXT_SIZE);
                PackageInfoDAOSyb pkgInfoDAO = new PackageInfoDAOSyb(conn, this.d_dbInfoTable, "archive..opc_get_key");
                PackageReportsDAOSyb pkgReportsDAO = new PackageReportsDAOSyb(conn, this.d_dbReportsTable);
                PackageFilesDAOSyb pkgFilesDAO = new PackageFilesDAOSyb(conn, this.d_dbFilesTable);
                PackageAuxFilesDAOSyb pkgAuxFilesDAO = new PackageAuxFilesDAOSyb(conn, this.d_dbAuxFilesTable);
                conn.setAutoCommit(false);
                logger.debug("PackageService::insertPackage() - insert package info");
                pkgInfoDAO.insertIfNotFound(pkg.getInfo());
                logger.debug("PackageService::insertPackage() - insert package reports");
                for (PackageReport report : pkg.getReports()) {
                    pkgReportsDAO.insertOrUpdate(report);
                }
                logger.debug("PackageService::insertPackage() - insert package files");
                pkgFilesDAO.insertIfNotFound(pkg.getFiles());
                logger.debug("PackageService::insertPackage() - insert package aux files");
                pkgAuxFilesDAO.insertPackageAuxFilesIfNotFound(pkg.getInfo().getPackageId(), pkg.getAuxFiles());
                logger.debug("PackageService::insertPackage()commit transaction");
                conn.commit();
            }
            catch (ConnectionServiceException e2) {
                message = e2.getMessage();
            }
            catch (SQLException e3) {
                message = e3.getMessage();
            }
            catch (DAOException e4) {
                try {
                    conn.rollback();
                    message = e4.getMessage();
                    logger.error("PackageService::insertPackage() - " + e4.getMessage());
                    logger.error("PackageService::insertPackage() - rollback transaction");
                }
                catch (SQLException ex) {
                    logger.error("PackageService::insertPackage() - " + ex.getMessage());
                    message = ex.getMessage();
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.setAutoCommit(true);
                        SybaseConnectionService.closeConnection(conn);
                    }
                    catch (ConnectionServiceException ex) {
                        logger.error("PackageService::insertPackage() - " + ex.getMessage());
                        message = ex.getMessage();
                    }
                    catch (SQLException ex) {
                        logger.error("PackageService::insertPackage() - " + ex.getMessage());
                        message = ex.getMessage();
                    }
                }
                if (message == null) break block28;
                throw new ServiceException(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deletePackage(String run_id, String instrument, Timestamp start, Timestamp stop) throws ServiceException {
        int res;
        block28: {
            String thisMethod = "PackageService::deletePackage()";
            logger.trace("PackageService::deletePackage()");
            res = -1;
            Package pkg = this.findPackage(run_id, instrument, start, stop);
            int pkgId = pkg.getInfo().getPackageId();
            Connection conn = null;
            String message = null;
            try {
                conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                PackageInfoDAOSyb pkgInfoDAO = new PackageInfoDAOSyb(conn, this.d_dbInfoTable, "archive..opc_get_key");
                PackageReportsDAOSyb pkgReportsDAO = new PackageReportsDAOSyb(conn, this.d_dbReportsTable);
                PackageFilesDAOSyb pkgFilesDAO = new PackageFilesDAOSyb(conn, this.d_dbFilesTable);
                PackageAuxFilesDAOSyb pkgAuxFilesDAO = new PackageAuxFilesDAOSyb(conn, this.d_dbAuxFilesTable);
                conn.setAutoCommit(false);
                logger.debug("PackageService::deletePackage() - delete aux files");
                pkgAuxFilesDAO.deletePackageAuxFiles(pkgId, pkg.getAuxFiles());
                logger.debug("PackageService::deletePackage() - delete package files");
                pkgFilesDAO.delete(pkg.getFiles());
                logger.debug("PackageService::deletePackage() - delete active package reports");
                pkgReportsDAO.delete(pkg.getActiveReports(false));
                List<PackageFile> remainingFiles = pkgFilesDAO.find(pkgId, new Timestamp(0L), new Timestamp(System.currentTimeMillis()));
                if (remainingFiles.size() == 0) {
                    logger.info("PackageService::deletePackage() - No more file in the package: removing all reports and package information");
                    logger.debug("PackageService::deletePackage() - delete all package reports");
                    pkgReportsDAO.delete(pkg.getReports());
                    logger.debug("PackageService::deletePackage() - delete package info");
                    pkgInfoDAO.delete(pkg.getInfo());
                }
                conn.commit();
                res = 0;
            }
            catch (ConnectionServiceException e2) {
                message = e2.getMessage();
                return (int)message;
            }
            catch (SQLException e3) {
                message = e3.getMessage();
                return (int)message;
            }
            catch (DAOException e4) {
                try {
                    conn.rollback();
                    message = "Rollback";
                }
                catch (SQLException ex) {
                    message = ex.getMessage();
                    return (int)message;
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.setAutoCommit(true);
                        SybaseConnectionService.closeConnection(conn);
                    }
                    catch (ConnectionServiceException ex) {
                        message = ex.getMessage();
                    }
                    catch (SQLException ex) {
                        message = ex.getMessage();
                    }
                }
                if (message == null) break block28;
                throw new ServiceException(message);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Package findPackage(String run_id, String instrument, Timestamp start, Timestamp stop) throws ServiceException {
        Package result;
        block24: {
            String message;
            Connection conn;
            block21: {
                String thisMethod = "PackageService::findPackage()";
                logger.trace("PackageService::findPackage()");
                result = new Package();
                conn = null;
                message = null;
                conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                SybaseConnectionService.executeStatement(conn, "set textsize " + this.MAX_TEXT_SIZE);
                PackageInfoDAOSyb pkgInfoDAO = new PackageInfoDAOSyb(conn, this.d_dbInfoTable, "archive..opc_get_key");
                PackageReportsDAOSyb pkgReportsDAO = new PackageReportsDAOSyb(conn, this.d_dbReportsTable);
                PackageFilesDAOSyb pkgFilesDAO = new PackageFilesDAOSyb(conn, this.d_dbFilesTable);
                PackageAuxFilesDAOSyb pkgAuxFilesDAO = new PackageAuxFilesDAOSyb(conn, this.d_dbAuxFilesTable);
                logger.debug("PackageService::findPackage() - find package info");
                PackageInfo info = pkgInfoDAO.find(run_id, instrument);
                if (info == null) {
                    throw new ServiceException("No information found about run_id " + run_id + " and instrument " + instrument);
                }
                logger.debug("PackageService::findPackage() - find package reports");
                List<PackageReport> reports = pkgReportsDAO.find(info.getPackageId());
                logger.debug("PackageService::findPackage() - find package files");
                List<PackageFile> files = pkgFilesDAO.find(info.getPackageId(), start, stop);
                ArrayList<String> fileIds = new ArrayList<String>();
                for (PackageFile file : files) {
                    fileIds.add(file.getFileId());
                }
                logger.debug("PackageService::findPackage() - find package aux files");
                Map<String, List<String>> auxFiles = pkgAuxFilesDAO.getAuxFiles(info.getPackageId(), fileIds);
                result.setInfo(info);
                result.setReports(reports);
                result.setFiles(files);
                result.setAuxFiles(auxFiles);
                if (conn == null) break block21;
                try {
                    SybaseConnectionService.closeConnection(conn);
                }
                catch (ConnectionServiceException ex) {
                    message = ex.getMessage();
                }
            }
            if (message != null) {
                throw new ServiceException(message);
            }
            break block24;
            catch (ConnectionServiceException e2) {
                block22: {
                    message = e2.getMessage();
                    if (conn == null) break block22;
                    try {
                        SybaseConnectionService.closeConnection(conn);
                    }
                    catch (ConnectionServiceException ex) {
                        message = ex.getMessage();
                    }
                }
                if (message != null) {
                    throw new ServiceException(message);
                }
            }
            catch (DAOException e3) {
                block23: {
                    message = e3.getMessage();
                    if (conn == null) break block23;
                    {
                        catch (Throwable throwable) {
                            if (conn != null) {
                                try {
                                    SybaseConnectionService.closeConnection(conn);
                                }
                                catch (ConnectionServiceException ex) {
                                    message = ex.getMessage();
                                }
                            }
                            if (message != null) {
                                throw new ServiceException(message);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        SybaseConnectionService.closeConnection(conn);
                    }
                    catch (ConnectionServiceException ex) {
                        message = ex.getMessage();
                    }
                }
                if (message != null) {
                    throw new ServiceException(message);
                }
            }
        }
        return result;
    }

    @Deprecated
    public void updateReleaseDates(String run_id, List<PackageFile> files, String reqId, String dbcmMail, String mailSubject, String propPeriodFilename) throws ServiceException {
        if (this.d_specialPeriods == null) {
            this.readSpecialPeriods(propPeriodFilename);
        }
        Connection conn = null;
        try {
            conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
        }
        catch (ConnectionServiceException e2) {
            throw new ServiceException(e2.getMessage());
        }
        try {
            conn.setAutoCommit(false);
            for (PackageFile file : files) {
                this.updateReleaseDate(conn, run_id, file.getFileId(), dbcmMail, mailSubject);
                this.logDownload(conn, run_id, file.getFileId());
            }
            String query = "INSERT INTO archive..rel_progs SELECT '" + run_id + "', 'DBPI', ";
            query = query + " datediff(ss, '1-1-1980', getdate()),'" + reqId + "', 'FTP', 1";
            logger.debug(query);
            SybaseConnectionService.executeStatement(conn, query);
            conn.commit();
        }
        catch (Exception e3) {
            try {
                logger.error(e3.getMessage());
                conn.rollback();
                throw new ServiceException(e3.getMessage());
            }
            catch (SQLException ex) {
                throw new ServiceException(ex.getMessage());
            }
        }
        finally {
            try {
                SybaseConnectionService.closeConnection(conn);
            }
            catch (ConnectionServiceException e4) {
                throw new ServiceException(e4.getMessage());
            }
        }
    }

    @Deprecated
    private void updateReleaseDate(Connection conn, String run_id, String dp_id, String dbcmMail, String mailSubject) throws ServiceException, ConnectionServiceException {
        ResultSet res;
        String query = "SELECT obs_mode FROM opc70..obs_runs WHERE run_code='" + run_id + "'";
        logger.debug(query);
        try {
            res = SybaseConnectionService.executeStatement(conn, query);
            if (res.next() && res.getString("obs_mode").toLowerCase().equals("v")) {
                logger.debug("Visitor mode: not updating release date");
                return;
            }
        }
        catch (SQLException e2) {
            throw new ServiceException(e2.getMessage());
        }
        query = "SELECT COUNT(*) FROM observations..rel_files WHERE dp_id='" + dp_id + "'";
        logger.debug(query);
        try {
            res = SybaseConnectionService.executeStatement(conn, query);
            if (res.next() && res.getInt(1) != 0) {
                logger.debug("Entry already present in rel_files: not updating");
                return;
            }
        }
        catch (SQLException e3) {
            throw new ServiceException(e3.getMessage());
        }
        Integer propPeriod = this.d_specialPeriods.get(run_id);
        query = propPeriod == null ? "SELECT dateadd(yy, 1, exp_start), " : "SELECT dateadd(dd, " + propPeriod + ", exp_start), ";
        query = query + " rel_date from observations..data_products dp LEFT OUTER JOIN observations..rel_files rf on dp.dp_id = rf.dp_id WHERE dp.dp_id='" + dp_id + "' AND rf.dp_id=NULL AND ( dp.dp_cat like 'SCIENCE%' or dp.dp_cat like 'ACQUISITION%' )";
        logger.debug(query);
        try {
            ResultSet res2 = SybaseConnectionService.executeStatement(conn, query);
            if (res2.next()) {
                Date evalRelDate = res2.getDate(1);
                Date relDate = res2.getDate(2);
                if (Math.abs(evalRelDate.getTime() - relDate.getTime()) > 1000L) {
                    this.sendMail(dbcmMail, mailSubject, "Release date of file " + dp_id + " has been modified by hand, not updating it");
                    return;
                }
            }
        }
        catch (SQLException e4) {
            throw new ServiceException(e4.getMessage());
        }
        query = "UPDATE observations..data_products SET rel_date = dateadd(";
        query = propPeriod == null ? query + "yy, 1, getdate()) " : query + "dd, " + this.d_specialPeriods.get(run_id) + ", getdate()) ";
        query = query + " WHERE dp_id = '" + dp_id + "'";
        query = query + " AND rel_date > getdate() AND ( dp_cat like 'SCIENCE%' or dp_cat like 'ACQUISITION%' )";
        query = query + " AND dp_id NOT IN (select dp_id FROM observations..rel_files";
        query = query + " where prog_id = '" + run_id + "' AND dp_id = '" + dp_id + "')";
        logger.debug(query);
        SybaseConnectionService.executeStatement(conn, query);
    }

    @Deprecated
    private void logDownload(Connection conn, String run_id, String dp_id) throws ServiceException, ConnectionServiceException {
        String query = "INSERT INTO observations..rel_files SELECT '" + dp_id + "',";
        query = query + " datediff(ss, '1-1-1980', dateadd(yy, 1, getdate())), '" + run_id + "'";
        logger.debug(query);
        SybaseConnectionService.executeStatement(conn, query);
    }

    @Deprecated
    private void readSpecialPeriods(String propPeriodFilename) {
        this.d_specialPeriods = new HashMap<String, Integer>();
        try {
            String line;
            FileReader specialPeriodsFile = new FileReader(propPeriodFilename);
            BufferedReader buf = new BufferedReader(specialPeriodsFile);
            int counter = 0;
            while ((line = buf.readLine()) != null) {
                String[] tokens = line.split("[ \\t]+");
                ++counter;
                if (tokens.length == 4) {
                    try {
                        this.d_specialPeriods.put(tokens[0], Integer.valueOf(tokens[2]));
                    }
                    catch (NumberFormatException e2) {
                        logger.warn("PackageService::readSpecialPeriods: line " + counter + " badly formatted");
                    }
                    continue;
                }
                logger.warn("PackageService::readSpecialPeriods: line " + counter + " badly formatted");
            }
        }
        catch (FileNotFoundException e3) {
            logger.fatal("PackageService::readSpecialPeriods: cannot read file " + propPeriodFilename + ", " + e3.getMessage());
            System.exit(-1);
        }
        catch (IOException e4) {
            logger.fatal("PackageService::readSpecialPeriods: cannot read file " + propPeriodFilename + ", " + e4.getMessage());
            System.exit(-1);
        }
    }

    private void sendMail(String receiver, String subject, String body) throws ServiceException {
        try {
            logger.info("Sending e-mail to: " + receiver);
            logger.info("Subject: " + subject);
            logger.info("Body: " + body);
            Properties props = System.getProperties();
            Session session = Session.getInstance(props);
            session.setDebug(true);
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress("pipack@eso.org"));
            message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(receiver, false));
            message.setHeader("X-Mailer", "msgsend");
            message.setSentDate(new java.util.Date());
            Transport transport = session.getTransport("smtp");
            message.setSubject(subject);
            message.setText(body);
            transport.connect("localhost", null, null);
            message.saveChanges();
            transport.sendMessage(message, message.getAllRecipients());
            transport.close();
            logger.info("E-Mail successfully sent");
        }
        catch (AddressException e2) {
            throw new ServiceException(e2.getMessage());
        }
        catch (MessagingException e3) {
            throw new ServiceException(e3.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPackageSize(Package pkg) throws ServiceException {
        Long result;
        block6: {
            String thisMethod = "PackageService::getPackageSize()";
            logger.trace("PackageService::getPackageSize()");
            String message = null;
            result = null;
            try {
                NgasFileDAOSyb ngasFilesDAO = new NgasFileDAOSyb(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword, this.d_dbNgasFilesTable);
                result = ngasFilesDAO.getSize(pkg.getFileIds());
                for (PackageReport report : pkg.getReports()) {
                    result = result + (long)report.getReport().length;
                }
            }
            catch (DAOException e2) {
                message = e2.getMessage();
                return message;
            }
            finally {
                if (message == null) break block6;
                throw new ServiceException(message);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean findByQCFilename(Integer pkgId, String filePath, String qcFilename) throws ServiceException {
        boolean result;
        block22: {
            String message;
            Connection conn;
            block19: {
                String thisMethod = "PackageService::findByQCFilename()";
                logger.trace("PackageService::findByQCFilename()");
                conn = null;
                message = null;
                result = false;
                conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                PackageFilesDAOSyb pkgFilesDAO = new PackageFilesDAOSyb(conn, this.d_dbFilesTable);
                result = pkgFilesDAO.findByQCFilename(pkgId, filePath, qcFilename);
                if (conn == null) break block19;
                try {
                    SybaseConnectionService.closeConnection(conn);
                }
                catch (ConnectionServiceException ex) {
                    message = ex.getMessage();
                }
            }
            if (message != null) {
                throw new ServiceException(message);
            }
            break block22;
            catch (ConnectionServiceException e2) {
                block20: {
                    message = e2.getMessage();
                    if (conn == null) break block20;
                    try {
                        SybaseConnectionService.closeConnection(conn);
                    }
                    catch (ConnectionServiceException ex) {
                        message = ex.getMessage();
                    }
                }
                if (message != null) {
                    throw new ServiceException(message);
                }
            }
            catch (DAOException e3) {
                block21: {
                    message = e3.getMessage();
                    if (conn == null) break block21;
                    {
                        catch (Throwable throwable) {
                            if (conn != null) {
                                try {
                                    SybaseConnectionService.closeConnection(conn);
                                }
                                catch (ConnectionServiceException ex) {
                                    message = ex.getMessage();
                                }
                            }
                            if (message != null) {
                                throw new ServiceException(message);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        SybaseConnectionService.closeConnection(conn);
                    }
                    catch (ConnectionServiceException ex) {
                        message = ex.getMessage();
                    }
                }
                if (message != null) {
                    throw new ServiceException(message);
                }
            }
        }
        return result;
    }

    @Deprecated
    public String getRequestId() throws ServiceException {
        try {
            Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
            CallableStatement cstmt = null;
            conn.setAutoCommit(true);
            cstmt = conn.prepareCall("{ call " + this.d_dbUniqueIdProcedure + " (?,?)}");
            cstmt.setString(1, "PI_REQ_ID");
            cstmt.registerOutParameter(2, 4);
            cstmt.execute();
            return new DecimalFormat("DBPI00000").format(cstmt.getInt(2));
        }
        catch (ConnectionServiceException e2) {
            throw new ServiceException(e2.getMessage());
        }
        catch (SQLException e3) {
            throw new ServiceException(e3.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isHeaderToBeUpdated(PackageFile file) throws ServiceException {
        String message;
        Boolean toBeUpdated;
        block13: {
            toBeUpdated = false;
            Connection conn = null;
            message = null;
            try {
                conn = SybaseConnectionService.getConnection(this.d_dbcmDbUrl, this.d_dbcmDbUserName, this.d_dbcmDbPassword);
                PackageFilesDAOSyb pkgFilesDAO = new PackageFilesDAOSyb(null, null, conn, this.d_dbcmDbTrackingTable);
                if (pkgFilesDAO.addHotflyData(file) != 0) {
                    throw new ServiceException("Could not have selective hotfly data for " + file.getFileId());
                }
                toBeUpdated = file.getKeyRepQualityFlag() < 16 && !file.getKeyRepIngestionDate().equals(file.getKeyRepLastModificationDate());
                if (conn == null) break block13;
            }
            catch (ConnectionServiceException e2) {
                try {
                    throw new ServiceException(e2.getMessage());
                    catch (DAOException e3) {
                        throw new ServiceException(e3.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            SybaseConnectionService.closeConnection(conn);
                        }
                        catch (ConnectionServiceException ex) {
                            message = ex.getMessage();
                        }
                    }
                    if (message != null) {
                        throw new ServiceException(message);
                    }
                    throw throwable;
                }
            }
            try {
                SybaseConnectionService.closeConnection(conn);
            }
            catch (ConnectionServiceException ex) {
                message = ex.getMessage();
            }
        }
        if (message != null) {
            throw new ServiceException(message);
        }
        return toBeUpdated;
    }

    public boolean isConfigured() {
        return this.d_configured;
    }

    public void setConfigured(boolean configured) {
        this.d_configured = configured;
    }

    public void setMaxTextSize(Integer size) {
        this.MAX_TEXT_SIZE = size;
    }

    public Integer getMaxTextSize() {
        return this.MAX_TEXT_SIZE;
    }
}

