/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.configuration;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import org.apache.log4j.Logger;
import org.eso.util.configuration.Configuration;
import org.eso.util.configuration.MetaConfigurationError;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class DBConfiguration
extends Configuration {
    static final Logger logger = Logger.getLogger(DBConfiguration.class);
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private int dbTimeout;
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    protected DBConfiguration(String metaConfigurationFilePath) throws NullPointerException, MetaConfigurationError {
        super(metaConfigurationFilePath);
    }

    protected boolean configureDB() {
        boolean retStatus = true;
        this.dbUrl = this.getString("database.url");
        this.dbUser = this.getString("database.username");
        this.dbPassword = this.getString("database.password");
        this.dbTimeout = this.getInteger("database.timeout");
        ComboPooledDataSource ds = new ComboPooledDataSource();
        try {
            ds.setDriverClass("com.sybase.jdbc3.jdbc.SybDriver");
        }
        catch (PropertyVetoException e2) {
            return false;
        }
        ds.setJdbcUrl("jdbc:sybase:Tds:" + this.dbUrl);
        ds.setUser(this.dbUser);
        ds.setPassword(this.dbPassword);
        ds.setInitialPoolSize(1);
        ds.setMinPoolSize(0);
        ds.setMaxPoolSize(10);
        ds.setMaxIdleTime(6600);
        ds.setMaxConnectionAge(39600);
        ds.setCheckoutTimeout(1000 * this.dbTimeout);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(ds);
        this.jdbcTemplate = new JdbcTemplate(transactionManager.getDataSource());
        this.jdbcTemplate.setQueryTimeout(this.dbTimeout);
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        return retStatus;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUsername() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public int getDbTimeout() {
        return this.dbTimeout;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }
}

