/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.configuration;

import jargs.gnu.CmdLineParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eso.util.configuration.Configuration;
import org.eso.util.configuration.ConfigurationOption;
import org.eso.util.configuration.PropertyHandler;
import org.eso.util.misc.WrappedString;

final class CommandLineHandler {
    static final Logger logger = Logger.getLogger(CommandLineHandler.class);
    private static final String classLogName = "CommandLineHandler";

    private CommandLineHandler() {
        String methodLogName = "CommandLineHandler::CommandLineHandler()";
        logger.trace("CommandLineHandler::CommandLineHandler()");
    }

    static boolean parseCommandLine(String[] arguments, Configuration configuration) throws NullPointerException {
        String methodLogName = "CommandLineHandler::parseCommandLine()";
        logger.trace("CommandLineHandler::parseCommandLine()");
        if (arguments == null || configuration == null) {
            String message = "CommandLineHandler::parseCommandLine() - arguments [" + arguments + "] and configuration [" + configuration + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        logger.debug("CommandLineHandler::parseCommandLine() - preparing command line parser.");
        CmdLineParser parser = new CmdLineParser();
        HashMap<ConfigurationOption, CmdLineParser.Option> optionMap = new HashMap<ConfigurationOption, CmdLineParser.Option>();
        Map<String, ConfigurationOption> configurationMap = configuration.getSelectedOptionMap(8);
        Iterator<ConfigurationOption> configurationMapIterator = configurationMap.values().iterator();
        ConfigurationOption currentOption = null;
        while (configurationMapIterator.hasNext()) {
            currentOption = configurationMapIterator.next();
            switch (currentOption.optionType) {
                case 1: {
                    optionMap.put(currentOption, parser.addStringOption(currentOption.commandLineChar, currentOption.commandLineName));
                    break;
                }
                case 2: {
                    optionMap.put(currentOption, parser.addBooleanOption(currentOption.commandLineChar, currentOption.commandLineName));
                    break;
                }
                case 3: {
                    optionMap.put(currentOption, parser.addIntegerOption(currentOption.commandLineChar, currentOption.commandLineName));
                    break;
                }
                default: {
                    String message = "CommandLineHandler::parseCommandLine() - configuration option [" + currentOption.optionName + "] type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] not recognised.";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            logger.debug("CommandLineHandler::parseCommandLine() - added option [" + currentOption.optionName + "] to the command line parser.");
        }
        logger.debug("CommandLineHandler::parseCommandLine() - parsing command line options.");
        try {
            parser.parse(arguments);
        }
        catch (Exception e2) {
            System.out.print("Error parsing command line: " + e2.getMessage() + "\n");
            logger.error("CommandLineHandler::parseCommandLine() - error parsing command line: " + e2.getMessage());
            return false;
        }
        Iterator optionMapIterator = optionMap.entrySet().iterator();
        Map.Entry currentOptionMapEntry = null;
        Object currentOptionValue = null;
        while (optionMapIterator.hasNext()) {
            currentOptionMapEntry = optionMapIterator.next();
            currentOption = (ConfigurationOption)currentOptionMapEntry.getKey();
            currentOptionValue = parser.getOptionValue((CmdLineParser.Option)currentOptionMapEntry.getValue());
            if (currentOptionValue == null) {
                logger.debug("CommandLineHandler::parseCommandLine() - the command line does not provide a value for option [" + currentOption.optionName + "].");
                continue;
            }
            if (ConfigurationOption.canOverrideValueSource(8, currentOption.getActualValueSource())) {
                logger.debug("CommandLineHandler::parseCommandLine() - setting option [" + currentOption.optionName + "] from the command line.");
                currentOption.setActualValue(currentOptionValue, 8, null);
                continue;
            }
            logger.debug("CommandLineHandler::parseCommandLine() - ignoring option [" + currentOption.optionName + "] which already has a higher priority [" + ConfigurationOption.getValueSourceString(currentOption.getActualValueSource()) + "] value than [" + ConfigurationOption.getValueSourceString(8) + "].");
        }
        configuration.setRemainingCommandLineArguments(parser.getRemainingArgs());
        logger.debug("CommandLineHandler::parseCommandLine() - command line parsing successfully completed.");
        return true;
    }

    static void printCommandLineHelpMessage(Configuration configuration) throws NullPointerException {
        String methodLogName = "CommandLineHandler::printCommandLineHelpMessage()";
        logger.trace("CommandLineHandler::printCommandLineHelpMessage()");
        if (configuration == null) {
            String message = "CommandLineHandler::printCommandLineHelpMessage() - configuration must not be null.";
            logger.fatal("CommandLineHandler::printCommandLineHelpMessage() - configuration must not be null.");
            throw new NullPointerException("CommandLineHandler::printCommandLineHelpMessage() - configuration must not be null.");
        }
        logger.debug("CommandLineHandler::printCommandLineHelpMessage() - printing command line help message to standard output.");
        Map<String, ConfigurationOption> optionMap = configuration.getSelectedOptionMap(8);
        Iterator<ConfigurationOption> optionMapIterator = optionMap.values().iterator();
        TreeSet<String> mandatorySet = new TreeSet<String>();
        TreeSet<String> additionalSet = new TreeSet<String>();
        ConfigurationOption currentOption = null;
        String currentText = null;
        String parameterTypeString = null;
        while (optionMapIterator.hasNext()) {
            currentOption = optionMapIterator.next();
            currentText = "";
            switch (currentOption.optionType) {
                case 1: 
                case 3: {
                    parameterTypeString = ConfigurationOption.getTypeString(currentOption.optionType);
                    break;
                }
                case 2: {
                    parameterTypeString = "";
                    break;
                }
                default: {
                    String message = "CommandLineHandler::printCommandLineHelpMessage() - configuration option [" + currentOption.optionName + "] type [" + ConfigurationOption.getTypeString(currentOption.optionType) + "] not recognised.";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            if (currentOption.commandLineChar != '\u0000') {
                currentText = currentText + "-" + currentOption.commandLineChar + " " + parameterTypeString + "\n";
            }
            if (currentOption.commandLineName != "") {
                currentText = currentText + "--" + currentOption.commandLineName + (parameterTypeString.equals("") ? "" : " " + parameterTypeString) + "\n";
            }
            if (currentText.equals("")) {
                String message = "CommandLineHandler::printCommandLineHelpMessage() - configuration option [" + currentOption.optionName + "] is marked as accepting source" + (ConfigurationOption.isSingleDefinedValueSource(currentOption.validValueSources) ? " [" : "s [") + ConfigurationOption.getValueSourceString(currentOption.validValueSources) + "] but does not have a short character or long name" + " to use on the command line.";
                logger.fatal(message);
                throw new AssertionError((Object)message);
            }
            if (currentOption.optionType != 2 && ConfigurationOption.isValidValueSource(1, currentOption.validValueSources)) {
                currentText = currentText + new WrappedString("  ", "Default value [" + currentOption.defaultValue + "].") + "\n";
            }
            if (!currentOption.helpText.equals("")) {
                currentText = currentText + new WrappedString("    ", currentOption.helpText) + "\n";
            }
            if (currentOption.validValueSources == 8) {
                mandatorySet.add(currentText);
                continue;
            }
            additionalSet.add(currentText);
        }
        boolean mandatoryOptions = !mandatorySet.isEmpty();
        boolean additionalOptions = !additionalSet.isEmpty();
        System.out.print("\nUsage: " + configuration.getString("application.command"));
        if (mandatoryOptions || additionalOptions) {
            System.out.print(" OPTIONS");
        }
        System.out.print("\n\n");
        if (!configuration.getString("application.help.header.text").equals("")) {
            System.out.print(new WrappedString("", configuration.getString("application.help.header.text")) + "\n\n");
        }
        if (mandatoryOptions) {
            System.out.print("Mandatory options:\n\n");
            Iterator mandatoryIterator = mandatorySet.iterator();
            while (mandatoryIterator.hasNext()) {
                System.out.print((String)mandatoryIterator.next() + "\n");
            }
        }
        if (additionalOptions) {
            if (mandatoryOptions) {
                System.out.print("Additional options:\n\n");
            }
            Iterator additionalIterator = additionalSet.iterator();
            while (additionalIterator.hasNext()) {
                System.out.print((String)additionalIterator.next() + "\n");
            }
        }
        PropertyHandler.printSystemPropertyHelpMessage(configuration);
        if (!configuration.getString("application.help.footer.text").equals("")) {
            System.out.print(new WrappedString("", configuration.getString("application.help.footer.text")) + "\n\n");
        }
        logger.debug("CommandLineHandler::printCommandLineHelpMessage() - successfully printed command line help message to standard output.");
    }
}

