/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.oca.backend.SelectionBlock;
import org.eso.oca.fits.OCAFileFactory;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.TypedHeaderCardException;
import org.eso.oca.parser.SimpleNode;

public class OCAState {
    static Logger logger = Logger.getLogger(OCAState.class);
    Hashtable symtab = new Hashtable();
    Hashtable inputFileSymtab = new Hashtable();
    Vector globCalibFiles = new Vector();
    Vector globInputFiles = new Vector();
    boolean isSelected = false;
    boolean isABValid = true;
    Integer minRet = new Integer(1);
    Integer maxRet = new Integer(1);
    String globRecipe = "";
    Vector globRecipeParams = new Vector();
    Vector extraInputFiles = new Vector();
    Vector associatedFiles = new Vector();
    Vector globVirtualProducts = new Vector();
    Object[] stack = new Object[1024];
    int top = -1;
    long opCounter = 0L;
    Vector<SelectionBlock> selectionBlocks = new Vector();
    Integer priority = 50;

    public void dumpSymtab() {
        Enumeration keys = this.symtab.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            System.out.println(key + " = " + this.symtab.get(key));
        }
    }

    public void updateSymtab(TypedHeaderCard[] requestedData) throws TypedHeaderCardException {
        this.symtab = OCAFileFactory.convertArrayOfCardsToHashtable(requestedData);
    }

    public TypedHeaderCard[] getMetaKeywords(SimpleNode node) throws TypedHeaderCardException {
        Collection metaKeywordCorpus = node.getMetaKeywordCorpus();
        TypedHeaderCard[] ret = new TypedHeaderCard[metaKeywordCorpus.size()];
        int i = 0;
        for (String metaKey : metaKeywordCorpus) {
            Object metaVal = this.symtab.get(metaKey);
            String metaValString = metaVal == null ? "''" : "'" + metaVal.toString() + "'";
            metaKey = TypedHeaderCard.formatKey(metaKey, 2);
            try {
                ret[i++] = new TypedHeaderCard(metaKey, metaValString, null);
            }
            catch (Exception e2) {
                String message = "Could not use metakeyword '" + metaKey + " = " + metaValString + "' to construct a TypedHeaderCard object.";
                logger.error(message);
                throw new TypedHeaderCardException(message, e2);
            }
        }
        return ret;
    }

    public Vector<SelectionBlock> getSelectionBlocks() {
        return this.selectionBlocks;
    }

    public void setSelectionBlocks(Vector<SelectionBlock> selectionBlocks) {
        this.selectionBlocks = selectionBlocks;
    }
}

