/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTTypeConst
extends SimpleNode {
    public int value;
    public static final int UNDEFINED = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int BOOLEAN = 3;
    public static final int STRING = 4;
    static Logger logger = Logger.getLogger(ASTTypeConst.class);

    public ASTTypeConst(int id) {
        super(id);
    }

    public ASTTypeConst(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        switch (this.value) {
            case 0: {
                state.stack[++state.top] = new UndefinedFITSValue();
                break;
            }
            case 1: {
                state.stack[++state.top] = new BigInteger("0");
                break;
            }
            case 2: {
                state.stack[++state.top] = new BigDecimal(0);
                break;
            }
            case 3: {
                state.stack[++state.top] = new Boolean(true);
                break;
            }
            case 4: {
                state.stack[++state.top] = new String();
                break;
            }
            default: {
                throw new InterpretationException("Type constant [" + this.value + "] not recognised.");
            }
        }
    }
}

