/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.oca.backend.SelectionBlock;
import org.eso.oca.fits.OCAFile;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTSelectAssociateStatement
extends SimpleNode {
    static final String DISTANCE = "DISTANCE";
    public String dataSource;
    public String alias;
    public Boolean addToInput;
    public String orderKeyword = "MJD-OBS";
    static Logger logger = Logger.getLogger(ASTSelectAssociateStatement.class);

    public ASTSelectAssociateStatement(int id) {
        super(id);
    }

    public ASTSelectAssociateStatement(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        StringBuffer msg;
        logger.trace("interpret() called.");
        Vector selectedFiles = new Vector();
        Vector associationDatabase = null;
        associationDatabase = this.dataSource.equals("calibFiles") ? state.globCalibFiles : state.globInputFiles;
        BigDecimal inputFileOrderKeyword = null;
        if (this.orderKeyword.equals("MJD-OBS")) {
            inputFileOrderKeyword = (BigDecimal)state.inputFileSymtab.get("MJD-OBS.MOD");
            if (inputFileOrderKeyword == null) {
                logger.warn("Modified MJD-OBS is not available in exemplar file " + state.inputFileSymtab.get("FILENAME"));
                inputFileOrderKeyword = (BigDecimal)state.inputFileSymtab.get("MJD-OBS");
                if (inputFileOrderKeyword == null) {
                    logger.error("MJD-OBS is not available in exemplar file " + state.inputFileSymtab.get("FILENAME"));
                    inputFileOrderKeyword = new BigDecimal(0.0);
                }
            }
        } else {
            inputFileOrderKeyword = (BigDecimal)state.inputFileSymtab.get(this.orderKeyword);
            if (inputFileOrderKeyword == null) {
                logger.error(this.orderKeyword + " is not available in exemplar file " + state.inputFileSymtab.get("FILENAME"));
                inputFileOrderKeyword = new BigDecimal(0.0);
            }
        }
        for (Hashtable state.symtab : associationDatabase) {
            this.jjtGetChild(0).interpret(state);
            if (!((Boolean)state.stack[state.top--]).booleanValue()) continue;
            Hashtable<String, Object> selectedFile = new Hashtable<String, Object>(state.symtab);
            selectedFile.put("ALIAS", this.alias);
            BigDecimal calibFileOrderKeyword = null;
            Object tmpMjdObs = selectedFile.get(this.orderKeyword);
            if (tmpMjdObs instanceof BigDecimal) {
                calibFileOrderKeyword = (BigDecimal)tmpMjdObs;
            } else {
                calibFileOrderKeyword = new BigDecimal(0.0);
                logger.debug("Null " + this.orderKeyword + " in calib file " + selectedFile.get("FILENAME"));
            }
            logger.debug("inputFileMjdObs=" + inputFileOrderKeyword + " calibFileMjdObs=" + calibFileOrderKeyword);
            selectedFile.put(DISTANCE, calibFileOrderKeyword.subtract(inputFileOrderKeyword).abs());
            selectedFiles.add(selectedFile);
        }
        OCAFile[] ocaFiles = new OCAFile[selectedFiles.size()];
        for (int i = 0; i < selectedFiles.size(); ++i) {
            ocaFiles[i] = new OCAFile((Hashtable)selectedFiles.get(i));
        }
        SelectionBlock sb = new SelectionBlock(this.alias, state.minRet, state.maxRet, ocaFiles);
        state.getSelectionBlocks().add(sb);
        Integer retCount = new Integer(selectedFiles.size());
        if (retCount.compareTo(state.minRet) < 0) {
            msg = new StringBuffer();
            msg.append("Could not find enough products of type " + this.alias);
            msg.append(" for " + state.inputFileSymtab.get("FILENAME") + ".");
            msg.append(" Requested " + state.minRet + ". Found " + retCount + ".");
            logger.warn(msg);
            state.isABValid = false;
        } else if (retCount.compareTo(state.maxRet) > 0) {
            msg = new StringBuffer();
            msg.append("Discarding " + (retCount - state.maxRet) + " surplus products of type " + this.alias + " for " + state.inputFileSymtab.get("FILENAME") + ".");
            logger.debug(msg);
            Collections.sort(selectedFiles, new CalibFileComparator());
            selectedFiles.setSize(state.maxRet);
        }
        if (this.addToInput.booleanValue()) {
            state.extraInputFiles.addAll(selectedFiles);
        } else {
            state.associatedFiles.addAll(selectedFiles);
        }
        state.minRet = new Integer(1);
        state.maxRet = new Integer(1);
    }

    private class CalibFileComparator
    implements Comparator {
        private CalibFileComparator() {
        }

        public int compare(Object a2, Object b2) {
            Object x = ((Hashtable)a2).get(ASTSelectAssociateStatement.DISTANCE);
            Object y = ((Hashtable)b2).get(ASTSelectAssociateStatement.DISTANCE);
            return ((BigDecimal)x).compareTo((BigDecimal)y);
        }
    }
}

