/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.viewers;

import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eso.gasgano.viewers.ExternalViewer;
import org.eso.gasgano.viewers.ExternalViewerException;

public class ExternalViewerFactory {
    private static ExternalViewerFactory instance;
    private ResourceBundle viewers = ResourceBundle.getBundle("org.eso.gasgano.viewers.ExternalViewers");

    public static synchronized ExternalViewerFactory getInstance() {
        if (instance == null) {
            instance = new ExternalViewerFactory();
        }
        return instance;
    }

    public static void setInstance(ExternalViewerFactory newInstance) {
        instance = newInstance;
    }

    private ExternalViewerFactory() {
    }

    public ExternalViewer getExternalViewer(String viewerType) throws ExternalViewerException {
        String viewerClass = this.viewers.getString(viewerType);
        ExternalViewer viewer = null;
        try {
            viewer = (ExternalViewer)Class.forName(viewerClass).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExternalViewerException("Unknown external viewer: " + viewerClass);
        }
        catch (InstantiationException ie) {
            throw new ExternalViewerException("Error instantiating external viewer: " + viewerClass + " (InstantiationException)");
        }
        catch (IllegalAccessException iae) {
            throw new ExternalViewerException("Error instantiating storage translator: " + viewerClass + " (IllegalAccessException)");
        }
        return viewer;
    }

    public Vector getViewerTypes() {
        Vector<String> rc = new Vector<String>();
        Enumeration<String> e2 = this.viewers.getKeys();
        while (e2.hasMoreElements()) {
            rc.addElement(e2.nextElement());
        }
        return rc;
    }
}

