/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.eso.gasgano.keyword.Keyword;

public class KeywordTable
extends AbstractTableModel {
    private Vector[] keywords = new Vector[2];
    private static String[] columnNames = new String[]{"Keyword Name", "Report Label"};
    private String tablePath = null;
    private boolean edited = false;
    private static final int COLUMN_COUNT = 2;

    public KeywordTable(String filePath) {
        this.tablePath = filePath;
        this.keywords[0] = new Vector();
        this.keywords[1] = new Vector();
        this.readFile();
        this.resetEditFlag();
    }

    public KeywordTable() {
        this.tablePath = null;
        this.keywords[0] = new Vector();
        this.keywords[1] = new Vector();
        this.insertRow(0);
        this.resetEditFlag();
    }

    public Vector getKeywordList() {
        return this.keywords[0];
    }

    public Vector getKeywordLabelList() {
        return this.keywords[1];
    }

    @Override
    public String getColumnName(int c2) {
        return columnNames[c2];
    }

    public String getTablePath() {
        return this.tablePath;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.keywords[0].size();
    }

    @Override
    public Object getValueAt(int r, int c2) {
        String rc = null;
        Vector col = this.keywords[c2];
        if (col != null) {
            try {
                rc = (String)col.elementAt(r);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                rc = new String("");
            }
        }
        if (rc == null) {
            rc = new String("");
        }
        return rc;
    }

    public int getColumnWidth(int column) {
        return 30;
    }

    @Override
    public boolean isCellEditable(int r, int c2) {
        return true;
    }

    public boolean readFile(String path) {
        this.tablePath = path;
        return this.readFile();
    }

    public boolean readFile() {
        if (this.tablePath == null) {
            return false;
        }
        boolean rc = true;
        this.keywords[0].removeAllElements();
        this.keywords[1].removeAllElements();
        try {
            String s = null;
            BufferedReader in = new BufferedReader(new FileReader(this.tablePath));
            while ((s = in.readLine()) != null) {
                int separator = -1;
                String keywordName = null;
                String reportName = null;
                separator = (s = s.trim()).indexOf(32);
                if (separator == -1) {
                    keywordName = s;
                    reportName = new String("");
                } else {
                    try {
                        keywordName = s.substring(0, separator);
                        reportName = s.substring(separator, s.length());
                        reportName = reportName.trim();
                    }
                    catch (StringIndexOutOfBoundsException e2) {
                        keywordName = s;
                        reportName = new String("");
                    }
                }
                keywordName = keywordName.toUpperCase();
                if (Keyword.validName(keywordName)) {
                    this.keywords[0].addElement(keywordName);
                    this.keywords[1].addElement(reportName);
                    continue;
                }
                rc = false;
            }
        }
        catch (IOException e3) {
            rc = false;
        }
        if (this.keywords[0].size() == 0) {
            this.insertRow(0);
        }
        this.fireTableDataChanged();
        return rc;
    }

    public boolean writeFile(String path) {
        this.tablePath = path;
        return this.writeFile();
    }

    public boolean writeFile() {
        if (this.tablePath == null) {
            return true;
        }
        boolean rc = true;
        try {
            FileWriter fw = new FileWriter(this.tablePath);
            PrintWriter pw = new PrintWriter((Writer)fw, true);
            int len = this.keywords[0].size();
            for (int i = 0; i < len; ++i) {
                String keywordName = (String)this.keywords[0].elementAt(i);
                String reportName = (String)this.keywords[1].elementAt(i);
                if (keywordName == null || keywordName.length() == 0) continue;
                if (reportName == null) {
                    pw.println(keywordName);
                    continue;
                }
                pw.println(keywordName + " " + reportName);
            }
            pw.flush();
            pw.close();
        }
        catch (IOException e2) {
            rc = false;
        }
        return rc;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Vector col;
        this.edited = true;
        String val = (String)aValue;
        if (columnIndex == 0) {
            val = val.trim();
            val = val.toUpperCase();
            val = val.replace(' ', '.');
        }
        if ((col = this.keywords[columnIndex]) != null) {
            col.setElementAt(val, rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void removeRow(int rowNum) {
        this.edited = true;
        try {
            this.keywords[0].removeElementAt(rowNum);
            this.keywords[1].removeElementAt(rowNum);
            this.fireTableDataChanged();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void insertRow(int rowNum) {
        this.edited = true;
        this.keywords[0].insertElementAt("", rowNum);
        this.keywords[1].insertElementAt("", rowNum);
        this.fireTableDataChanged();
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void resetEditFlag() {
        this.edited = false;
    }
}

