/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eso.dfs.gui.SwingFileChooser;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.gui.KeywordListEditor;
import org.eso.gasgano.gui.KeywordTable;
import org.eso.gasgano.properties.PropertyDB;

public class KeywordListEditorFrame
extends JFrame
implements ActionListener {
    private KeywordListEditor editorPanel = null;
    private KeywordTable kwTable = null;
    private static final String newItem = "New";
    private static final String openItem = "Open";
    private static final String saveAsItem = "Save As";
    private static final String quitItem = "Quit";
    private JFileChooser fileChooser = null;

    public static void main(String[] args) {
        KeywordListEditorFrame myApp = null;
        myApp = args.length > 0 ? new KeywordListEditorFrame(args[0]) : new KeywordListEditorFrame();
        myApp.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        myApp.pack();
        myApp.setVisible(true);
    }

    public KeywordListEditorFrame() {
        this.kwTable = new KeywordTable();
        this.init();
        this.setTitle("Keyword List Editor (no file loaded)");
    }

    public KeywordListEditorFrame(String kwFile) {
        this.kwTable = new KeywordTable(kwFile);
        this.init();
        this.setTitle("Keyword List Editor: " + kwFile);
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.editorPanel = new KeywordListEditor(this.kwTable);
        this.getContentPane().add((Component)this.editorPanel, "Center");
        this.addMenu();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                KeywordListEditorFrame.this.closeEditor();
            }
        });
    }

    private void addMenu() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        MenuItem mi = null;
        mi = new MenuItem(openItem);
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem(newItem);
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem(saveAsItem);
        mi.addActionListener(this);
        m.add(mi);
        mi = new MenuItem(quitItem);
        mi.addActionListener(this);
        m.add(mi);
        mb.add(m);
        this.setMenuBar(mb);
    }

    public void closeEditor() {
        this.editorPanel.finishEditing();
        if (this.kwTable.getTablePath() != null || !this.kwTable.isEdited() || this.kwTable.isEdited() && this.userQuestion("The keyword list is not saved to a file.\nAre you sure you want to close the editor?", "Warning")) {
            this.kwTable.resetEditFlag();
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getActionCommand() == quitItem) {
            this.closeEditor();
        } else if (a2.getActionCommand() == saveAsItem) {
            this.saveAsFile();
        } else if (a2.getActionCommand() == openItem) {
            this.openFile();
        } else if (a2.getActionCommand() == newItem) {
            this.newFile();
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            DFSDataModel dm = DFSDataModel.getDataModel();
            String kwDir = PropertyDB.getInstance().getProperty("KEYWORDLIST_DIR");
            this.fileChooser = new SwingFileChooser(kwDir);
        } else {
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    private void openFile() {
        JFileChooser openChooser = this.getFileChooser();
        openChooser.setFileSelectionMode(0);
        openChooser.setDialogType(0);
        openChooser.setDialogTitle("Select keyword list file");
        openChooser.setApproveButtonText("Load");
        openChooser.setMultiSelectionEnabled(false);
        if (openChooser.showOpenDialog(this) == 0 && openChooser.getSelectedFile() != null) {
            String selectedFile = openChooser.getSelectedFile().getPath();
            if (!this.kwTable.readFile(selectedFile)) {
                this.userMessage("Errors reading: " + selectedFile);
            }
            this.setTitle("Keyword List Editor: " + selectedFile);
        }
        this.kwTable.resetEditFlag();
    }

    private void newFile() {
        for (int i = this.kwTable.getRowCount() - 1; i >= 0; --i) {
            this.kwTable.removeRow(i);
        }
        this.kwTable.insertRow(0);
        this.writeToNewFile("Enter new keyword list name", "OK");
        this.kwTable.resetEditFlag();
    }

    private void saveAsFile() {
        this.editorPanel.finishEditing();
        this.writeToNewFile("Save keyword list in file", "Save");
        this.kwTable.resetEditFlag();
    }

    private void writeToNewFile(String dialogTitle, String approveButton) {
        JFileChooser saveChooser = this.getFileChooser();
        saveChooser.setFileSelectionMode(0);
        saveChooser.setDialogType(1);
        saveChooser.setDialogTitle(dialogTitle);
        saveChooser.setApproveButtonText(approveButton);
        saveChooser.setMultiSelectionEnabled(false);
        if (saveChooser.showSaveDialog(this) == 0 && saveChooser.getSelectedFile() != null) {
            String selectedFile = saveChooser.getSelectedFile().getPath();
            File newFile = new File(selectedFile);
            boolean save = true;
            try {
                if (!newFile.exists() || JOptionPane.showConfirmDialog(this, "Overwrite " + selectedFile + "?", selectedFile + " exists", 2) == 0) {
                    save = this.kwTable.writeFile(selectedFile);
                }
            }
            catch (SecurityException e2) {
                save = false;
            }
            if (!save) {
                this.userMessage("Errors writing: " + selectedFile);
            } else if (this.kwTable.getTablePath() != null) {
                this.setTitle("Keyword List Editor: " + this.kwTable.getTablePath());
            }
        }
    }

    public void userMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }

    public boolean userQuestion(String msg, String title) {
        return JOptionPane.showConfirmDialog(this, msg, title, 2) == 0;
    }
}

