/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.eso.gasgano.gui.KeywordTable;

public class KeywordListEditor
extends JPanel
implements ActionListener,
CellEditorListener,
MouseListener {
    private KeywordTable kwTable = null;
    private JTable table = null;
    private JButton insertRow = null;
    private JButton deleteRow = null;
    private boolean readOnlyMode = false;
    private static final String insertRowLabel = "Insert Row";
    private static final String deleteRowLabel = "Delete Row";

    public KeywordListEditor(KeywordTable kwt) {
        super(new BorderLayout());
        this.kwTable = kwt;
        this.table = new JTable(this.kwTable);
        this.table.setCellSelectionEnabled(false);
        this.table.getDefaultEditor(this.table.getColumnClass(0)).addCellEditorListener(this);
        this.table.getDefaultEditor(this.table.getColumnClass(1)).addCellEditorListener(this);
        this.insertRow = new JButton(insertRowLabel);
        this.insertRow.addMouseListener(this);
        this.deleteRow = new JButton(deleteRowLabel);
        this.deleteRow.addActionListener(this);
        JPanel lowerPanel = new JPanel();
        lowerPanel.add(this.insertRow);
        lowerPanel.add(this.deleteRow);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)lowerPanel, "South");
        this.deleteRow.setEnabled(this.kwTable.getRowCount() != 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnlyMode = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("usage: <keyword file>");
            System.exit(0);
        }
        JFrame frame = new JFrame("Example keyword list: " + args[0]);
        KeywordTable kwt = new KeywordTable(args[0]);
        if (!kwt.readFile()) {
            System.out.println("Error reading in file: " + args[0]);
        }
        KeywordListEditor editor = new KeywordListEditor(kwt);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(editor);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    public KeywordTable getKeywordTable() {
        return this.kwTable;
    }

    @Override
    public void actionPerformed(ActionEvent a2) {
        if (a2.getSource() == this.deleteRow) {
            this.deleteSelectedRow();
        }
    }

    public void finishEditing() {
        if (this.table.isEditing()) {
            int row = this.table.getSelectedRow();
            TableCellEditor comp = this.table.getCellEditor();
            if (comp != null && comp instanceof DefaultCellEditor) {
                ((DefaultCellEditor)comp).stopCellEditing();
            }
            this.table.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private void deleteSelectedRow() {
        this.finishEditing();
        int selRow = this.table.getSelectedRow();
        int rowCountNow = this.table.getRowCount();
        if (selRow < 0) {
            selRow = this.table.getRowCount() - 1;
        }
        if (selRow > -1) {
            this.kwTable.removeRow(selRow);
            if (!this.isReadOnly() && !this.kwTable.writeFile()) {
                this.userMessage("Error saving file: " + this.kwTable.getTablePath());
            }
            if (selRow >= rowCountNow - 1) {
                selRow = rowCountNow - 2;
            }
            if (selRow >= 0) {
                final int row = selRow;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KeywordListEditor.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                });
            } else {
                this.table.clearSelection();
            }
        }
        this.deleteRow.setEnabled(this.kwTable.getRowCount() != 0);
    }

    private void insertBlankRow(boolean after) {
        this.finishEditing();
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            selRow = this.table.getRowCount() - 1;
        }
        if (selRow < 0) {
            after = true;
        }
        if (after) {
            this.kwTable.insertRow(selRow + 1);
        } else {
            this.kwTable.insertRow(selRow);
            ++selRow;
        }
        final int row = selRow;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeywordListEditor.this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        });
        if (!this.isReadOnly() && !this.kwTable.writeFile()) {
            this.userMessage("Error saving file: " + this.kwTable.getTablePath());
        }
        this.deleteRow.setEnabled(this.kwTable.getRowCount() != 0);
    }

    @Override
    public void editingCanceled(ChangeEvent e2) {
    }

    @Override
    public void editingStopped(ChangeEvent e2) {
        if (!this.isReadOnly() && !this.kwTable.writeFile()) {
            this.userMessage("Error saving file: " + this.kwTable.getTablePath());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if ((e2.getModifiers() & 4) != 0) {
            this.insertBlankRow(false);
        }
        if ((e2.getModifiers() & 0x10) != 0) {
            this.insertBlankRow(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    public void userMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg);
    }
}

