/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eso.dfs.gui.RecallingComboBox;
import org.eso.dfs.gui.SharedListComboBoxModel;
import org.eso.gasgano.keyword.AndKeywordExpr;
import org.eso.gasgano.keyword.BinaryKeywordExpr;
import org.eso.gasgano.keyword.DefaultBoolKeywordExpr;
import org.eso.gasgano.keyword.EqKeywordExpr;
import org.eso.gasgano.keyword.GEKeywordExpr;
import org.eso.gasgano.keyword.GTKeywordExpr;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordExpression;
import org.eso.gasgano.keyword.LEKeywordExpr;
import org.eso.gasgano.keyword.LTKeywordExpr;
import org.eso.gasgano.keyword.LikeKeywordExpr;
import org.eso.gasgano.keyword.NEqKeywordExpr;
import org.eso.gasgano.keyword.NotLikeKeywordExpr;
import org.eso.gasgano.keyword.OrKeywordExpr;
import org.eso.gasgano.keyword.SharedKeywordList;

public class ExpressionBuilder
extends JPanel {
    private RESyntax theSyntax = new RESyntax(RESyntax.RE_SYNTAX_PERL5);
    private String stringReg = "^\\\"[^\\\"]*\\\"$";
    private RE rhsExp;
    private Frame owner;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode selectedNode;
    private JScrollPane treeView;
    private JTree tree;
    private JPanel rulePanel;
    private Action add;
    private Action delete;
    private Action edit;
    private Action changeToNode;
    private final String addLeafStr = "Add Leaf";
    private final String insertNodeStr = "Insert Node";
    private final String deleteExprStr = "Delete";
    private final String editStr = "Edit";
    public static final String defaultLeafValue = "KEYWORD = \"value\"";
    public static final String defaultNodeValue = "AND";
    public static Color panelColor = new Color(180, 180, 180);

    public ExpressionBuilder(Frame o) {
        super(new BorderLayout());
        this.owner = o;
        this.init();
    }

    private void init() {
        JPanel p = new JPanel();
        this.setBackground(panelColor);
        p.setBackground(panelColor);
        this.add = new AbstractAction("Add Leaf"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ExpressionBuilder.this.treeOpAdd();
            }
        };
        this.changeToNode = new AbstractAction("Insert Node"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ExpressionBuilder.this.treeOpChangeToNode();
            }
        };
        this.delete = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ExpressionBuilder.this.treeOpDelete();
            }
        };
        this.edit = new AbstractAction("Edit"){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ExpressionBuilder.this.treeOpEdit();
            }
        };
        JButton b2 = new JButton(this.add);
        b2.setBackground(panelColor);
        p.add(b2);
        b2 = new JButton(this.changeToNode);
        b2.setBackground(panelColor);
        p.add(b2);
        b2 = new JButton(this.delete);
        b2.setBackground(panelColor);
        p.add(b2);
        b2 = new JButton(this.edit);
        b2.setBackground(panelColor);
        p.add(b2);
        this.add((Component)p, "South");
        UIDefaults defaults = UIManager.getDefaults();
        defaults.put("Tree.leafIcon", new ImageIcon(""));
        defaults.put("Tree.openIcon", new ImageIcon(""));
        defaults.put("Tree.closedIcon", new ImageIcon(""));
        defaults.put("Tree.hash", Color.black);
        this.root = new DefaultMutableTreeNode(defaultLeafValue);
        this.refreshTree();
        try {
            this.rhsExp = new RE(this.stringReg);
        }
        catch (REException ree) {
            System.out.println("ExpressionBuilder: could not instantiate gnu regular expression");
        }
        this.nodeSelected(null);
    }

    private TreePath getPathToRoot(DefaultMutableTreeNode node) {
        int size = 0;
        TreePath rc = null;
        Vector<DefaultMutableTreeNode> tmpVect = new Vector<DefaultMutableTreeNode>();
        Object[] tmpArray = null;
        do {
            tmpVect.addElement(node);
        } while ((node = (DefaultMutableTreeNode)node.getParent()) != null);
        size = tmpVect.size();
        tmpArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            tmpArray[i] = tmpVect.elementAt(size - i - 1);
        }
        rc = new TreePath(tmpArray);
        return rc;
    }

    private void nodeSelected(DefaultMutableTreeNode node) {
        this.selectedNode = node;
        if (this.selectedNode != null) {
            this.edit.setEnabled(true);
            this.delete.setEnabled(true);
            if (this.selectedNode.isLeaf()) {
                this.add.setEnabled(false);
                this.changeToNode.setEnabled(true);
            } else {
                this.add.setEnabled(true);
                this.changeToNode.setEnabled(false);
            }
        } else {
            this.add.setEnabled(false);
            this.delete.setEnabled(false);
            this.changeToNode.setEnabled(false);
            this.edit.setEnabled(false);
        }
        this.edit.setEnabled(this.selectedNode != null);
    }

    public DefaultBoolKeywordExpr convertNodeToKeywordExpr(DefaultMutableTreeNode node) {
        DefaultBoolKeywordExpr rc = null;
        String nodeString = node.getUserObject().toString();
        if (node.getChildCount() >= 2) {
            if (nodeString.equals(defaultNodeValue)) {
                rc = new AndKeywordExpr();
            } else if (nodeString.equals("OR")) {
                rc = new OrKeywordExpr();
            } else {
                System.out.println("convertNodeToKeywordExpr <" + node + "> returning null as it was not AND or OR");
                this.userMessage("Error, operator: " + nodeString + " not recognized.");
                rc = null;
            }
        } else {
            System.out.println("convertNodeToKeywordExpr <" + node + "> returning null it has less than 2 children.");
            this.userMessage("Error, operator: " + nodeString + " must have two or more branches/sub-expressions.");
        }
        return rc;
    }

    public BinaryKeywordExpr convertLeafToKeywordExpr(DefaultMutableTreeNode node) {
        BinaryKeywordExpr rc = null;
        String exp = node.getUserObject().toString().trim();
        String lhVal = null;
        String rhVal = null;
        String opVal = null;
        int endToken = -1;
        try {
            endToken = exp.indexOf(34) == 0 && exp.length() > 1 ? exp.indexOf(34, 1) : exp.indexOf(32) - 1;
            lhVal = exp.substring(0, endToken + 1);
            lhVal = lhVal.trim();
            exp = exp.substring(endToken + 1, exp.length()).trim();
            endToken = exp.indexOf(32);
            opVal = exp.substring(0, endToken).trim();
            rhVal = exp.substring(endToken + 1, exp.length()).trim();
        }
        catch (StringIndexOutOfBoundsException e2) {
            opVal = null;
            lhVal = null;
            rhVal = null;
        }
        if (lhVal != null && rhVal != null && opVal != null) {
            Object lhs = KeywordExpression.stringToValue(lhVal);
            Object rhs = KeywordExpression.stringToValue(rhVal);
            if (lhs != null && rhs != null && opVal != null) {
                if (opVal.equals("=")) {
                    rc = new EqKeywordExpr(lhs, rhs);
                } else if (opVal.equals("!=")) {
                    rc = new NEqKeywordExpr(lhs, rhs);
                } else if (opVal.equals("<")) {
                    rc = new LTKeywordExpr(lhs, rhs);
                } else if (opVal.equals(">")) {
                    rc = new GTKeywordExpr(lhs, rhs);
                } else if (opVal.equals("<=")) {
                    rc = new LEKeywordExpr(lhs, rhs);
                } else if (opVal.equals(">=")) {
                    rc = new GEKeywordExpr(lhs, rhs);
                } else if (opVal.equals("like")) {
                    rc = new LikeKeywordExpr(lhs, rhs);
                } else if (opVal.equals("notlike")) {
                    rc = new NotLikeKeywordExpr(lhs, rhs);
                } else {
                    System.out.println("convertLeafToKeywordExpr: returning null as operator not found.");
                    this.userMessage("Error, operator: " + opVal + " not recognized.");
                }
            }
        } else {
            System.out.println("convertLeafToKeywordExpr: returning null as string not parsed successfully");
            this.userMessage("Error, expression: " + node.getUserObject().toString() + " could not be parsed.");
        }
        return rc;
    }

    public DefaultBoolKeywordExpr convertToKeywordExpr(DefaultMutableTreeNode node) {
        DefaultBoolKeywordExpr rc = null;
        if (node.getChildCount() > 0) {
            rc = this.convertNodeToKeywordExpr(node);
            if (rc != null) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultBoolKeywordExpr child = this.convertToKeywordExpr((DefaultMutableTreeNode)node.getChildAt(i));
                    if (child == null) {
                        System.out.println("convertToKeywordExpr: return null as child " + i + " was null");
                        rc = null;
                        break;
                    }
                    rc.add(child);
                }
            }
        } else {
            rc = this.convertLeafToKeywordExpr(node);
        }
        return rc;
    }

    public void setKeywordExpression(KeywordExpression kwe) {
        this.root = ExpressionBuilder.treeCopy(kwe.getExpressionTree());
        this.refreshTree();
    }

    public KeywordExpression getKeywordExpression() {
        DefaultBoolKeywordExpr exp = this.convertToKeywordExpr(this.root);
        KeywordExpression rc = null;
        if (exp != null) {
            rc = new KeywordExpression(exp);
        }
        return rc;
    }

    public static DefaultMutableTreeNode treeCopy(DefaultMutableTreeNode t) {
        DefaultMutableTreeNode rc = new DefaultMutableTreeNode(t.toString());
        Enumeration<TreeNode> e2 = t.children();
        while (e2.hasMoreElements()) {
            rc.add(ExpressionBuilder.treeCopy((DefaultMutableTreeNode)e2.nextElement()));
        }
        return rc;
    }

    void userMessage(String msg) {
        JOptionPane.showMessageDialog(this.owner, msg);
    }

    private void refreshTree() {
        if (this.treeView != null) {
            this.remove(this.treeView);
        }
        this.tree = new JTree(this.root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setEditable(false);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                int selRow = ExpressionBuilder.this.tree.getRowForLocation(e2.getX(), e2.getY());
                TreePath selPath = ExpressionBuilder.this.tree.getPathForLocation(e2.getX(), e2.getY());
                if (selPath != null && e2.getClickCount() == 2) {
                    ExpressionBuilder.this.treeOpEdit();
                }
            }
        });
        this.tree.setVisibleRowCount(1000);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.tree.setExpandsSelectedPaths(false);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                ExpressionBuilder.this.nodeSelected((DefaultMutableTreeNode)e2.getPath().getLastPathComponent());
            }
        });
        this.treeView = new JScrollPane(this.tree);
        this.add((Component)this.treeView, "Center");
        this.validate();
        this.nodeSelected(null);
    }

    public void treeOpEdit() {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.getChildCount() == 0) {
            BinaryOpExprEditor editor = new BinaryOpExprEditor(this.owner, this.selectedNode);
            editor.setModal(true);
            editor.setSize(600, 240);
            Point p = this.owner.getLocation();
            Dimension d2 = this.owner.getSize();
            p.move(p.x + d2.width / 2 - 250, p.y + d2.height / 2);
            editor.setLocation(p);
            editor.show();
        } else {
            this.tree.expandPath(this.tree.getLeadSelectionPath());
            BoolExprEditor editor = new BoolExprEditor(this.owner, this.selectedNode);
            editor.setModal(true);
            editor.setSize(300, 120);
            Point p = this.owner.getLocation();
            Dimension d3 = this.owner.getSize();
            p.move(p.x + d3.width / 2 - 250, p.y + d3.height / 2);
            editor.setLocation(p);
            editor.show();
        }
        this.refreshTree();
    }

    private void treeOpAdd() {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.isLeaf()) {
            return;
        }
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(defaultLeafValue);
        this.selectedNode.add(child);
        this.refreshTree();
    }

    private void treeOpDelete() {
        Object dmtn = null;
        DefaultMutableTreeNode sibling = null;
        boolean nodeIndex = false;
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode == this.root) {
            this.treeOpChangeToLeaf();
            return;
        }
        if (this.selectedNode.getNextSibling() == null && this.selectedNode.getPreviousSibling() == null) {
            sibling = (DefaultMutableTreeNode)this.selectedNode.getParent();
        } else if (this.selectedNode.getNextSibling() != null) {
            sibling = this.selectedNode.getNextSibling();
        } else if (this.selectedNode.getPreviousSibling() != null) {
            sibling = this.selectedNode.getPreviousSibling();
        }
        this.selectedNode.removeFromParent();
        this.refreshTree();
        this.tree.setSelectionPath(this.getPathToRoot(sibling));
    }

    private void treeOpChangeToLeaf() {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.isLeaf()) {
            return;
        }
        String previousContent = (String)this.selectedNode.getFirstLeaf().getUserObject();
        this.selectedNode.removeAllChildren();
        this.selectedNode.setUserObject(previousContent);
        this.refreshTree();
    }

    private void treeOpChangeToNode() {
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.isLeaf()) {
            String previousContent = (String)this.selectedNode.getUserObject();
            this.selectedNode.setUserObject(defaultNodeValue);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(previousContent);
            this.selectedNode.add(child);
            child = new DefaultMutableTreeNode(defaultLeafValue);
            this.selectedNode.add(child);
            this.refreshTree();
        }
    }

    private boolean isLegalRHS(String rhs) {
        REMatch theMatch = null;
        if (rhs.equals("")) {
            return false;
        }
        if (rhs.indexOf(34) == -1) {
            return true;
        }
        theMatch = this.rhsExp.getMatch(rhs);
        return theMatch != null;
    }

    public static Color getDefaultPanelColor() {
        return panelColor;
    }

    public static void setDefaultPanelColor(Color panelColor) {
        ExpressionBuilder.panelColor = panelColor;
    }

    class BoolExprEditor
    extends JDialog
    implements ActionListener {
        private DefaultMutableTreeNode targetNode;
        private JButton okButton;
        private JButton cancelButton;
        private final String[] operators;
        private JComboBox operator;
        private boolean changesSaved;

        BoolExprEditor(Frame owner, DefaultMutableTreeNode n) {
            super(owner, "Editing expression operator");
            this.targetNode = null;
            this.okButton = null;
            this.cancelButton = null;
            this.operators = new String[]{ExpressionBuilder.defaultNodeValue, "OR"};
            this.operator = null;
            this.changesSaved = false;
            this.targetNode = n;
            this.init();
        }

        private void init() {
            this.getContentPane().setLayout(new BorderLayout());
            this.operator = new JComboBox<String>(this.operators);
            this.operator.setSelectedItem(this.targetNode.toString());
            this.operator.addActionListener(this);
            JPanel upperPanel = new JPanel();
            upperPanel.add(this.operator);
            this.getContentPane().add((Component)upperPanel, "North");
            this.okButton = new JButton("ok");
            this.okButton.addActionListener(this);
            this.cancelButton = new JButton("cancel");
            this.cancelButton.addActionListener(this);
            JPanel lowerPanel = new JPanel();
            lowerPanel.add(this.okButton);
            lowerPanel.add(this.cancelButton);
            this.getContentPane().add((Component)lowerPanel, "South");
        }

        public boolean okSelected() {
            return this.changesSaved;
        }

        @Override
        public void actionPerformed(ActionEvent a2) {
            if (a2.getSource() == this.okButton) {
                if (this.saveChanges()) {
                    this.setVisible(false);
                    this.dispose();
                }
            } else if (a2.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.dispose();
            }
        }

        private boolean saveChanges() {
            this.targetNode.setUserObject(this.operator.getSelectedItem());
            this.changesSaved = true;
            return this.changesSaved;
        }
    }

    class BinaryOpExprEditor
    extends JDialog
    implements ActionListener {
        private DefaultMutableTreeNode targetNode;
        private JButton okButton;
        private JButton cancelButton;
        private final String[] operators;
        private final String keywordSyntax = "Keyword values (upper case with 'dot' notation): TPL.ID, ORIGFILE, OBS.NAME, RA";
        private final String stringSyntax = "String values (contained within double quotes): \"flat_001\", \"SCIENCE\", \"23/04/97\", \"12.3\"";
        private final String numberSyntax = "Numeric values : 12, 13.5, 0.7, 45.4f, -23";
        private final String likeSyntax = "like/notlike (String value using '*' as a wild card): \"*flat*\", \"NTT*\"";
        private RecallingComboBox lhsText;
        private JTextField rhsText;
        private JComboBox operator;
        private boolean changesSaved;
        private String lhsTextBack;
        private String rhsTextBack;

        BinaryOpExprEditor(Frame owner, DefaultMutableTreeNode n) {
            super(owner, "Editing boolean expression");
            this.operators = new String[]{"=", "!=", "<", "<=", ">", ">=", "like", "notlike"};
            this.keywordSyntax = "Keyword values (upper case with 'dot' notation): TPL.ID, ORIGFILE, OBS.NAME, RA";
            this.stringSyntax = "String values (contained within double quotes): \"flat_001\", \"SCIENCE\", \"23/04/97\", \"12.3\"";
            this.numberSyntax = "Numeric values : 12, 13.5, 0.7, 45.4f, -23";
            this.likeSyntax = "like/notlike (String value using '*' as a wild card): \"*flat*\", \"NTT*\"";
            this.changesSaved = false;
            this.targetNode = n;
            this.init();
        }

        private void init() {
            BinaryKeywordExpr expr = null;
            expr = ExpressionBuilder.this.convertLeafToKeywordExpr(this.targetNode);
            if (expr == null) {
                expr = new EqKeywordExpr((Object)new Keyword("KEYWORD", null), new String("VALUE"));
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.lhsTextBack = KeywordExpression.valueToString(expr.getLeftValue());
            this.rhsTextBack = KeywordExpression.valueToString(expr.getRightValue());
            SharedKeywordList kwList = SharedKeywordList.getListFromRegistry("DefaultKeywordList");
            this.lhsText = new RecallingComboBox(new SharedListComboBoxModel(kwList));
            if (this.lhsTextBack.length() > 0) {
                kwList.add(this.lhsTextBack);
                this.lhsText.setSelectedItem(this.lhsTextBack);
            }
            this.lhsText.addActionListener(this);
            this.rhsText = new JTextField(KeywordExpression.valueToString(expr.getRightValue()), 15);
            this.rhsText.addActionListener(this);
            this.operator = new JComboBox<String>(this.operators);
            this.operator.setSelectedItem(expr.getOpString());
            this.operator.addActionListener(this);
            JPanel upperPanel = new JPanel();
            upperPanel.add(this.lhsText);
            upperPanel.add(this.operator);
            upperPanel.add(this.rhsText);
            this.getContentPane().add((Component)upperPanel, "North");
            JPanel instructionPanel = new JPanel(new GridLayout(4, 1));
            JLabel instruction = new JLabel("Keyword values (upper case with 'dot' notation): TPL.ID, ORIGFILE, OBS.NAME, RA");
            instruction.setForeground(Color.black);
            instructionPanel.add(instruction);
            instruction = new JLabel("String values (contained within double quotes): \"flat_001\", \"SCIENCE\", \"23/04/97\", \"12.3\"");
            instruction.setForeground(Color.black);
            instructionPanel.add(instruction);
            instruction = new JLabel("Numeric values : 12, 13.5, 0.7, 45.4f, -23");
            instruction.setForeground(Color.black);
            instructionPanel.add(instruction);
            instruction = new JLabel("like/notlike (String value using '*' as a wild card): \"*flat*\", \"NTT*\"");
            instruction.setForeground(Color.black);
            instructionPanel.add(instruction);
            instructionPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.getContentPane().add((Component)instructionPanel, "Center");
            this.okButton = new JButton("ok");
            this.okButton.addActionListener(this);
            this.cancelButton = new JButton("cancel");
            this.cancelButton.addActionListener(this);
            JPanel lowerPanel = new JPanel();
            lowerPanel.add(this.okButton);
            lowerPanel.add(this.cancelButton);
            this.getContentPane().add((Component)lowerPanel, "South");
            this.lhsText.requestFocus();
        }

        public boolean okSelected() {
            return this.changesSaved;
        }

        @Override
        public void actionPerformed(ActionEvent a2) {
            if (a2.getSource() == this.okButton || a2.getSource() == this.rhsText) {
                if (Keyword.validName(this.lhsText.getText())) {
                    if (ExpressionBuilder.this.isLegalRHS(this.rhsText.getText())) {
                        if (this.saveChanges()) {
                            this.setVisible(false);
                            this.dispose();
                        }
                    } else {
                        this.rhsText.setText(this.rhsTextBack);
                    }
                } else {
                    this.lhsText.setText(this.lhsTextBack);
                }
            } else if (a2.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.dispose();
            }
        }

        private boolean saveChanges() {
            String lhs = this.lhsText.getText();
            String rhs = this.rhsText.getText();
            if (KeywordExpression.stringToValue(lhs) == null) {
                ExpressionBuilder.this.userMessage("Value: " + lhs + " is invalid");
            } else if (KeywordExpression.stringToValue(rhs) == null) {
                ExpressionBuilder.this.userMessage("Value: " + rhs + " is invalid");
            } else if (this.operator.getSelectedItem() == null) {
                ExpressionBuilder.this.userMessage("Please select an operator");
            } else {
                try {
                    rhs = Float.valueOf(rhs).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.targetNode.setUserObject(new String(lhs + " " + this.operator.getSelectedItem().toString() + " " + rhs));
                this.changesSaved = true;
            }
            return this.changesSaved;
        }
    }
}

