/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.eso.dfs.datatransfer.FileListEvent;
import org.eso.dfs.datatransfer.FileListImportListener;
import org.eso.dfs.datatransfer.FileListTransferHandler;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.gui.DFSFileTreeCellRenderer;
import org.eso.gasgano.gui.DFSFileTreeTableModel;
import org.eso.gasgano.gui.JTreeTable;
import org.eso.gasgano.properties.GasProp;

public class DFSFileTreeTable
extends JTreeTable
implements PropertyChangeListener {
    private Vector selectionVector = new Vector();
    private List importListeners = new ArrayList();
    private String selectedDir = null;

    public DFSFileTreeTable(DFSFileTreeTableModel model) {
        super(model);
        this.getTree().getSelectionModel().setSelectionMode(4);
        this.getTree().setCellRenderer(new DFSFileTreeCellRenderer());
        this.setIntercellSpacing(new Dimension(5, 1));
        this.setupDataTransfer();
    }

    private void setupDataTransfer() {
        this.setDragEnabled(true);
        this.setTransferHandler(new FileListTransferHandler(false, true){

            @Override
            protected List exportFileList(JComponent c2) {
                Iterator i = DFSFileTreeTable.this.getSelectedFiles().iterator();
                ArrayList<File> rc = new ArrayList<File>();
                while (i.hasNext()) {
                    String fileName = (String)i.next();
                    rc.add(new File(fileName));
                }
                if (rc.isEmpty()) {
                    rc = null;
                }
                return rc;
            }

            @Override
            protected void importFileList(JComponent c2, List fileList) {
                DFSFileTreeTable.this.fireListListImportEvent(new FileListEvent(fileList));
            }
        });
    }

    public void addFileListImportListener(FileListImportListener l) {
        this.removeFileListImportListener(l);
        this.importListeners.add(l);
    }

    public void removeFileListImportListener(FileListImportListener l) {
        this.importListeners.remove(l);
    }

    private void fireListListImportEvent(FileListEvent event) {
        Iterator i = this.importListeners.iterator();
        while (i.hasNext()) {
            ((FileListImportListener)i.next()).importFileListEvent(event);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("columWidth")) {
            int value = (Integer)pce.getNewValue();
            String name = (String)((TableColumn)pce.getSource()).getHeaderValue();
            if (!name.equals("File")) {
                GasProp.columnSizeChanged(0, name, value);
            }
        }
    }

    public void registerColumnListener() {
        Enumeration<TableColumn> e2 = this.getColumnModel().getColumns();
        while (e2.hasMoreElements()) {
            e2.nextElement().addPropertyChangeListener(this);
        }
    }

    public void setColumnWidths() {
        DefaultTableColumnModel tcm = (DefaultTableColumnModel)this.getColumnModel();
        Vector columnSize = null;
        TableColumn tCol = tcm.getColumn(0);
        if (GasProp.getProperties().getProperty("SHORT_FILENAME").toString().equals("true")) {
            tCol.setMinWidth(370);
        } else {
            tCol.setMinWidth(450);
        }
        Vector columnName = GasProp.getProperties().fsDisplayColumns;
        columnSize = GasProp.getProperties().fsDisplayColumnsSize;
        Enumeration<TableColumn> e2 = this.getColumnModel().getColumns();
        while (e2.hasMoreElements()) {
            tCol = e2.nextElement();
            int pos = columnName.indexOf((String)tCol.getHeaderValue());
            if (pos == -1 || pos >= columnSize.size()) continue;
            int width = 0;
            if (columnSize.elementAt(pos) instanceof String) {
                try {
                    width = Integer.parseInt((String)columnSize.elementAt(pos));
                }
                catch (NumberFormatException nfe) {}
            } else if (columnSize.elementAt(pos) instanceof Integer) {
                width = (Integer)columnSize.elementAt(pos);
            }
            if (width == 0) continue;
            tCol.setWidth(width);
        }
    }

    public Vector getSelectedFiles() {
        Vector rc = this.selectionVector;
        rc.removeAllElements();
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof OBComponent)) continue;
                OBComponent obc = (OBComponent)obj;
                DFSFile dFile = obc.getSourceFile();
                rc.addElement(dFile.getPathString());
            }
        }
        return rc;
    }

    public String getSelectedDir() {
        String rc = null;
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths != null) {
            DFSFileTreeTableModel model = (DFSFileTreeTableModel)this.tree.getModel();
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (model.isLeaf(obj)) continue;
                String dir = model.getDirectory(obj);
                if (rc == null) {
                    rc = dir;
                    continue;
                }
                if (rc.equals(dir)) continue;
                rc = null;
                break;
            }
        }
        return rc;
    }

    public Vector getSelectedOBComponents() {
        Vector rc = this.selectionVector;
        rc.removeAllElements();
        TreePath[] paths = this.getTree().getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof OBComponent)) continue;
                rc.addElement(obj);
            }
        }
        return rc;
    }

    public String getSelectedInstrument() {
        Vector selVect = this.getSelectedOBComponents();
        String rc = null;
        int c2 = 0;
        for (int i = 0; i < selVect.size(); ++i) {
            if (!(selVect.elementAt(i) instanceof KeywordContainerOBComponent)) continue;
            KeywordContainerOBComponent ffoc = (KeywordContainerOBComponent)selVect.elementAt(i);
            if (c2 == 0) {
                rc = ffoc.getInstrument();
                ++c2;
                continue;
            }
            ++c2;
            if (ffoc.getInstrument() == null || rc.equals(ffoc.getInstrument())) continue;
            rc = null;
            return rc;
        }
        return rc;
    }
}

