/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import org.eso.gasgano.gui.KeywordListAdaptor;
import org.eso.gasgano.gui.ListAdaptor;
import org.eso.gasgano.gui.PropertyCellEditor;
import org.eso.gasgano.gui.PropertyEditorSubPanel;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.MenuTableModel;

public class DBDisplayPanel
extends PropertyEditorSubPanel {
    private GasProp gpi;
    private JTable menuTable = new JTable();
    private MenuTableModel menuTableModel;
    private JTable dbDispKeys;
    private KeywordListAdaptor dbDispKeysModel;

    public DBDisplayPanel(GasProp gp) {
        this.menuTableModel = new MenuTableModel(gp);
        this.menuTable.setModel(this.menuTableModel);
        this.menuTable.setDefaultEditor(this.menuTable.getColumnClass(1), new PropertyCellEditor());
        this.menuTable.setCellSelectionEnabled(true);
        this.menuTable.setPreferredScrollableViewportSize(new Dimension(240, 100));
        JScrollPane scrollPane = new JScrollPane(this.menuTable);
        JPanel jpTable2 = new JPanel(new BorderLayout());
        jpTable2.setBorder(new TitledBorder("Database pull-down menus associations"));
        jpTable2.add((Component)scrollPane, "Center");
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.setLayout(new BorderLayout());
        JPanel jpTable1 = this.setupDBDisplayColumnsTable(gp);
        this.loadProperties(gp);
        if (GasProp.isEnvironmentSafe()) {
            this.add((Component)jpTable1, "North");
            this.add((Component)jpTable2, "South");
        }
    }

    private JPanel setupDBDisplayColumnsTable(GasProp gp) {
        String dbHeaderLabel = new String("Database - Displayed Keywords");
        JButton insertRow = new JButton("Insert Row");
        insertRow.setToolTipText("Left-click for insert below, right-click for insert above.");
        insertRow.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if ((e2.getModifiers() & 4) != 0) {
                    DBDisplayPanel.this.insertBlankRow(DBDisplayPanel.this.dbDispKeys, false);
                }
                if ((e2.getModifiers() & 0x10) != 0) {
                    DBDisplayPanel.this.insertBlankRow(DBDisplayPanel.this.dbDispKeys, true);
                }
            }
        });
        JButton deleteRow = new JButton("Delete Row");
        deleteRow.setToolTipText("Delete selected row.");
        deleteRow.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                DBDisplayPanel.this.deleteSelectedRow(DBDisplayPanel.this.dbDispKeys);
            }
        });
        this.dbDispKeys = new JTable();
        this.dbDispKeys.setCellSelectionEnabled(true);
        this.dbDispKeys.setPreferredScrollableViewportSize(new Dimension(240, 140));
        this.dbDispKeysModel = new KeywordListAdaptor((List)gp.dbDisplayColumns, dbHeaderLabel, true);
        this.dbDispKeys.setModel(this.dbDispKeysModel);
        this.dbDispKeys.setDefaultEditor(this.dbDispKeys.getColumnClass(0), new PropertyCellEditor());
        TableColumn mColumn = this.dbDispKeys.getColumn(dbHeaderLabel);
        mColumn.setMinWidth(210);
        mColumn.setResizable(false);
        JScrollPane scrollPane1 = new JScrollPane(this.dbDispKeys);
        scrollPane1.setVerticalScrollBarPolicy(22);
        JPanel jpLower = new JPanel();
        jpLower.add(insertRow);
        jpLower.add(deleteRow);
        JPanel rc = new JPanel(new BorderLayout());
        rc.setBorder(new TitledBorder("Database - Displayed Keywords"));
        rc.add((Component)scrollPane1, "Center");
        rc.add((Component)jpLower, "South");
        return rc;
    }

    @Override
    public void loadProperties(GasProp gp) {
        this.gpi = gp;
        this.dbDispKeysModel.setData(gp.dbDisplayColumns);
        this.menuTable.getDefaultEditor(this.menuTable.getColumnClass(0)).cancelCellEditing();
        this.menuTableModel.loadProperties(this.gpi);
    }

    @Override
    public String saveProperties() {
        String rc = null;
        this.dbDispKeys.getDefaultEditor(this.dbDispKeys.getColumnClass(0)).stopCellEditing();
        for (int i = 0; i < this.gpi.dbDisplayColumns.size(); ++i) {
            if (!this.gpi.dbDisplayColumns.elementAt(i).toString().equals("") && !this.gpi.dbDisplayColumns.elementAt(i).toString().equals("*INVALID*") && this.gpi.dbDisplayColumns.elementAt(i) != null) continue;
            this.gpi.dbDisplayColumns.removeElementAt(i);
        }
        Object[][] tableContent = this.menuTableModel.getTableContent();
        if (tableContent[0][1].equals("")) {
            tableContent[0][1] = "Custom  Menu1";
        }
        if (tableContent[1][1].equals("")) {
            tableContent[1][1] = "Custom  Menu2";
        }
        if (tableContent[2][1].equals("")) {
            tableContent[2][1] = "Custom  Menu3";
        }
        if (tableContent[3][1].equals("")) {
            tableContent[3][1] = "Custom  Menu4";
        }
        this.gpi.put("MENU_CUSTOM1_LBL", tableContent[0][1]);
        this.gpi.put("MENU_CUSTOM2_LBL", tableContent[1][1]);
        this.gpi.put("MENU_CUSTOM3_LBL", tableContent[2][1]);
        this.gpi.put("MENU_CUSTOM4_LBL", tableContent[3][1]);
        this.gpi.put("MENU_CUSTOM1", tableContent[0][2]);
        this.gpi.put("MENU_CUSTOM2", tableContent[1][2]);
        this.gpi.put("MENU_CUSTOM3", tableContent[2][2]);
        this.gpi.put("MENU_CUSTOM4", tableContent[3][2]);
        this.gpi.put("MENU_RETRIEVE", tableContent[4][2]);
        this.menuTableModel.setTableContent(tableContent);
        return rc;
    }

    @Override
    public int restartRequired() {
        this.menuTable.getDefaultEditor(this.menuTable.getColumnClass(0)).stopCellEditing();
        return 0;
    }

    private void insertBlankRow(JTable table, boolean after) {
        int selRow = table.getSelectedRow();
        if (selRow < 0) {
            int n = selRow = after ? table.getRowCount() - 1 : 0;
        }
        if (this.isDebug()) {
            System.out.println("selected row: " + selRow);
        }
        if (after && table.getRowCount() != 0) {
            ((ListAdaptor)table.getModel()).insertRow(selRow + 1, "");
            table.setRowSelectionInterval(selRow + 1, selRow + 1);
        } else {
            ((ListAdaptor)table.getModel()).insertRow(selRow, "");
            table.setRowSelectionInterval(selRow, selRow);
        }
    }

    private void deleteSelectedRow(JTable table) {
        int selRow = table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        if (this.isDebug()) {
            System.out.println("selected row: " + selRow);
        }
        ((ListAdaptor)table.getModel()).removeRow(selRow);
    }
}

