/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.datamodel.gui.FitsFileDisplay;
import org.eso.gasgano.datamodel.gui.FitsTableModel;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.datamodel.gui.ResultsContainer;
import org.eso.gasgano.gui.GUIUtils;

public class ResultsComponent {
    private DBOBComponent dbComp = null;
    private KeywordContainerOBComponent fileComp = null;
    private String id = null;
    private Object father = null;
    private static JLabel rawLabel = new JLabel(new ImageIcon(Object.class.getResource("/org/eso/gasgano/gui/icons/rawfits.gif")), 0);

    public ResultsComponent(String id) {
        this.id = id;
        this.fileComp = (KeywordContainerOBComponent)DFSDataModel.getDataModel().getObComponentByFilesystemBaseName(id + ".fits");
        if (this.fileComp == null) {
            // empty if block
        }
    }

    public void setFather(Object father) {
        this.father = father;
    }

    public Object getFather() {
        return this.father;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.toString();
    }

    public JComponent getTreeCellComponent() {
        JLabel cell = null;
        Color foreGround = null;
        cell = rawLabel;
        foreGround = GUIUtils.dataBaseColor;
        if (this.getFather() != null && this.getFather() instanceof ResultsContainer && ((ResultsContainer)this.getFather()).isLabel()) {
            foreGround = new Color(1.0f, 0.5f, 0.1f);
        }
        cell.setText(this.toString());
        cell.setForeground(foreGround);
        return cell;
    }

    public String[] getDisplayData() {
        if (this.fileComp != null) {
            return this.fileComp.getDisplayData();
        }
        String[] tmpString = new String[]{"Not Found", "Not Found", "Not Found"};
        return tmpString;
    }

    public JComponent getDisplayComponent() {
        FitsFileDisplay rc = null;
        if (this.fileComp != null) {
            String title = null;
            title = this.toString() + " " + this.fileComp.getClassification();
            rc = new FitsFileDisplay(title, new FitsTableModel((FitsFile)this.fileComp.getSourceFile()));
        }
        return rc;
    }
}

