/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.eso.gasgano.datamodel.filesystem.FitsExtKeywordBlock;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordBlock;

public class FitsTableModel
extends AbstractTableModel {
    private String pathString;
    private DBOBComponent dComp;
    private Vector keywordList;
    private boolean filtered = false;
    private KeywordBlock header;
    private FitsExtKeywordBlock[] extensions;
    private static final String[] columns = new String[]{"Keyword", "Value", "Extension"};

    public FitsTableModel(FitsFile f) {
        this.header = f.getHeaderKeywordBlock();
        this.pathString = f.getPathString();
        this.keywordList = FitsFile.getKeywordFilter();
        if (f.extensionsInMemory()) {
            this.extensions = new FitsExtKeywordBlock[f.getExtensionCount()];
            for (int i = 0; i < this.extensions.length; ++i) {
                this.extensions[i] = f.getExtension(i);
            }
        }
    }

    public FitsTableModel(DBOBComponent d2) {
        this.dComp = d2;
        this.header = d2.getHeaderKeywordBlock();
        this.keywordList = DBOBComponent.getKeywordFilter();
        this.pathString = this.dComp.getId();
    }

    public String getFileName() {
        return this.pathString;
    }

    @Override
    public String getColumnName(int c2) {
        String rc = null;
        if (c2 >= 0 && c2 < columns.length) {
            rc = columns[c2];
        }
        return rc;
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        int rc = this.getExtensionStartRow();
        if (this.extensions != null) {
            for (int i = 0; i < this.extensions.length; ++i) {
                rc += this.getExtensionSize(i);
            }
        }
        return rc;
    }

    private int getExtensionSize(int ext) {
        int rc = this.extensions == null || this.extensions.length <= ext || ext < 0 ? 0 : (this.isFiltered() ? this.keywordList.size() + 1 : this.extensions[ext].size());
        return rc;
    }

    public void setFiltered(boolean f) {
        if (f) {
            this.keywordList = FitsFile.getKeywordFilter();
        }
        this.filtered = this.keywordList != null && f;
        this.fireTableDataChanged();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public Object getValueAt(int r, int c2) {
        Object rc = null;
        int xsr = this.getExtensionStartRow();
        if (r >= xsr && this.extensions != null) {
            r -= xsr;
            for (int i = 0; i < this.extensions.length; ++i) {
                if (r < this.getExtensionSize(i)) {
                    if (c2 == 2) {
                        rc = new Integer(i + 1);
                    } else if (r == 0 || !this.isFiltered()) {
                        Keyword k = this.extensions[i].getKeywordAt(r);
                        if (c2 == 0) {
                            rc = k.getName();
                        } else if (c2 == 1) {
                            rc = k.getValue();
                        }
                    } else {
                        Keyword k;
                        String name = (String)this.keywordList.elementAt(r - 1);
                        rc = c2 == 0 ? name : ((k = this.extensions[i].getKeyword(name)) == null ? "<not found>" : k.getValue());
                    }
                    break;
                }
                r -= this.getExtensionSize(i);
            }
        } else if (!this.isFiltered()) {
            if (c2 == 2) {
                rc = new Integer(0);
            } else {
                Keyword k = null;
                k = this.header.getKeywordAt(r);
                rc = c2 == 0 ? k.getName() : k.getValue();
            }
        } else if (c2 == 2) {
            rc = new Integer(0);
        } else {
            Keyword k;
            String name = (String)this.keywordList.elementAt(r);
            rc = c2 == 0 ? name : ((k = this.header.getKeyword(name)) == null ? "<not found>" : k.getValue());
        }
        return rc;
    }

    public int getExtensionCount() {
        return this.extensions == null ? -1 : this.extensions.length;
    }

    public String getExtensionName(int x) {
        String rc = this.extensions != null && x >= 0 && x < this.getExtensionCount() ? this.extensions[x].getName() : null;
        return rc;
    }

    private int getExtensionStartRow() {
        int rc = this.isFiltered() ? this.keywordList.size() : this.header.size();
        return rc;
    }

    public int getExtensionStartRow(int i) {
        int rc = -1;
        if (i == -1) {
            rc = 0;
        } else if (this.extensions != null && i >= 0 && i < this.extensions.length) {
            rc = this.getExtensionStartRow();
            --i;
            while (i >= 0) {
                rc += this.getExtensionSize(i);
                --i;
            }
        }
        return rc;
    }

    @Override
    public boolean isCellEditable(int r, int c2) {
        return false;
    }
}

