/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import java.util.Enumeration;
import org.eso.gasgano.datamodel.InterContainer;
import org.eso.gasgano.datamodel.Program;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.tools.SortedHashtable;

public class Observation {
    private String id = null;
    private String desc = null;
    private Program program = null;
    private SortedHashtable obComponents = null;
    private SortedHashtable intermediates = null;

    public Observation(String name) {
        this.id = name;
        this.obComponents = new SortedHashtable(true);
        this.intermediates = new SortedHashtable();
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String rc = this.desc;
        if (rc == null) {
            rc = this.getId();
        }
        return rc;
    }

    public void setDescription(String s) {
        this.desc = s;
    }

    public void addObComponent(OBComponent obc) {
        if (this.getComponent(obc.getId()) == null) {
            this.obComponents.put(obc.getId(), obc);
        }
    }

    public void removeObComponent(OBComponent obc) {
        this.obComponents.remove(obc.getId());
    }

    public OBComponent getComponent(String id) {
        return (OBComponent)this.obComponents.get(id);
    }

    public boolean isEmpty() {
        return this.obComponents.isEmpty() && this.intermediates.isEmpty();
    }

    public SortedHashtable getComponents() {
        return this.obComponents;
    }

    public OBComponent getComponentAt(int i) {
        return (OBComponent)this.obComponents.elementAt(i);
    }

    public int getIndexOfComponent(OBComponent comp) {
        return this.obComponents.indexOf(comp);
    }

    public int getComponentCount() {
        return this.obComponents.size();
    }

    public void cleanup() {
        this.obComponents.clear();
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public InterContainer findIntermediate(String name) {
        return (InterContainer)this.intermediates.get(name);
    }

    public InterContainer addIntermediate(String name) {
        InterContainer rc = null;
        rc = this.findIntermediate(name);
        if (rc == null) {
            rc = new InterContainer(name);
            this.intermediates.put(name, rc);
        }
        return rc;
    }

    public SortedHashtable getIntermediates() {
        return this.intermediates;
    }

    public InterContainer getIntermediateAt(int i) {
        return (InterContainer)this.intermediates.elementAt(i);
    }

    public int getIndexOfIntermediate(InterContainer inter) {
        return this.intermediates.indexOf(inter);
    }

    public int getIntermediateCount() {
        return this.intermediates.size();
    }

    public void removeIntermediate(InterContainer inter) {
        this.intermediates.remove(inter.getId());
    }

    public SortedHashtable getDescendants() {
        Object tmpObject;
        SortedHashtable tmpHash = null;
        if (this.getIntermediateCount() == 0) {
            return this.getComponents();
        }
        if (this.getComponentCount() == 0) {
            return this.getIntermediates();
        }
        tmpHash = new SortedHashtable();
        Enumeration e2 = this.intermediates.keys();
        while (e2.hasMoreElements()) {
            tmpObject = e2.nextElement();
            tmpHash.put(tmpObject, this.intermediates.get(tmpObject));
        }
        e2 = this.obComponents.keys();
        while (e2.hasMoreElements()) {
            tmpObject = e2.nextElement();
            tmpHash.put(tmpObject, this.obComponents.get(tmpObject));
        }
        return tmpHash;
    }
}

