/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import java.io.File;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameType;

public class FrameTest
extends TestCase {
    public FrameTest(String name) {
        super(name);
    }

    public void testFrame() {
        Frame f1 = new Frame(new File("f1.fits"));
        Frame f2 = new Frame(new File("f2.fits"));
        FrameTest.different(f1, f2);
        f1.setFile(new File("same.fits"));
        f2.setFile(new File("./same.fits"));
        FrameTest.same(f1, f2);
        f1.setTag("testing");
        FrameTest.different(f1, f2);
        f2.setTag("testing");
        FrameTest.same(f1, f2);
        f1.setLevel(FrameLevel.INTERMEDIATE);
        FrameTest.different(f1, f2);
        f2.setLevel(FrameLevel.TEMPORARY);
        FrameTest.different(f1, f2);
        f2.setLevel(FrameLevel.INTERMEDIATE);
        FrameTest.same(f1, f1);
        f1.setGroup(FrameGroup.RAW);
        FrameTest.different(f1, f2);
        f2.setGroup(FrameGroup.PRODUCT);
        FrameTest.different(f1, f2);
        f2.setGroup(FrameGroup.RAW);
        FrameTest.same(f1, f2);
        f1.setType(FrameType.MATRIX);
        FrameTest.different(f1, f2);
        f2.setType(FrameType.TABLE);
        FrameTest.different(f1, f2);
        f2.setType(FrameType.MATRIX);
        FrameTest.same(f1, f2);
    }

    public void testFrameGroup() {
        FrameTest.assertEquals("CALIB", FrameGroup.CALIB.getName());
        FrameTest.assertEquals("PRODUCT", FrameGroup.PRODUCT.getName());
        FrameTest.assertEquals("RAW", FrameGroup.RAW.getName());
    }

    public void testFrameLevel() {
        FrameTest.assertEquals("FINAL", FrameLevel.FINAL.getName());
        FrameTest.assertEquals("INTERMEDIATE", FrameLevel.INTERMEDIATE.getName());
        FrameTest.assertEquals("TEMPORARY", FrameLevel.TEMPORARY.getName());
    }

    public void testFrameType() {
        FrameTest.assertEquals("IMAGE", FrameType.IMAGE.getName());
        FrameTest.assertEquals("MATRIX", FrameType.MATRIX.getName());
        FrameTest.assertEquals("TABLE", FrameType.TABLE.getName());
    }

    private static void same(Frame f1, Frame f2) {
        FrameTest.assertTrue(f1.equals(f2));
        FrameTest.assertTrue(f1.hashCode() == f2.hashCode());
        FrameTest.checkClone(f1);
    }

    private static void different(Frame f1, Frame f2) {
        FrameTest.assertTrue(!f1.equals(f2));
        FrameTest.assertTrue("hashcodes match - not necessarily wrong, but probably is", f1.hashCode() != f2.hashCode());
        FrameTest.checkClone(f1);
        FrameTest.checkClone(f2);
    }

    private static void checkClone(Frame f) {
        FrameTest.assertEquals(f, new Frame(f));
    }

    public static TestSuite suite() {
        return new TestSuite(FrameTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(FrameTest.suite());
    }
}

