/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.eso.cpl.FrameList;
import org.eso.cpl.MarkedFrameList;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Request;
import org.eso.cpl.gui.DataColumnTable;
import org.eso.cpl.gui.GUIUtils;
import org.eso.cpl.gui.MarkedFrameTableModel;
import org.eso.cpl.gui.NamingPanel;
import org.eso.cpl.gui.ParameterTableModel;
import org.eso.cpl.gui.TableComponentMouseListener;

public class RequestPanel
extends JPanel {
    private final LockableTable paramTable_ = new LockableTable();
    private final LockableTable inFrameTable_ = new LockableTable();
    private final JComponent headingBox_;
    private final JComponent controlBox_;
    private final NamingPanel namingPanel_;
    private Request request_;
    private boolean isLocked_;

    public RequestPanel() {
        this((String)null);
    }

    public RequestPanel(String productDirPath) {
        super(new BorderLayout());
        Box mainBox = Box.createVerticalBox();
        this.add((Component)mainBox, "Center");
        mainBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GUIUtils.configureTable(this.paramTable_);
        GUIUtils.configureTable(this.inFrameTable_);
        GUIUtils.enableFileListDragDrop(this.inFrameTable_);
        String deleteCurrent = "DELETE_CURRENT_FRAME";
        this.inFrameTable_.addMouseListener(new TableComponentMouseListener());
        this.inFrameTable_.getInputMap().put(KeyStroke.getKeyStroke(127, 0), deleteCurrent);
        this.inFrameTable_.getActionMap().put(deleteCurrent, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (RequestPanel.this.request_ != null) {
                    RequestPanel.this.removeSelectedInputFrame();
                }
            }
        });
        mainBox.add(GUIUtils.wrapInBorder(GUIUtils.wrapInScroller(this.paramTable_), "Parameters"));
        mainBox.add(Box.createVerticalStrut(5));
        JScrollPane scroller = GUIUtils.wrapInScroller(this.inFrameTable_);
        GUIUtils.enableFileListDragDrop(scroller);
        mainBox.add(GUIUtils.wrapInBorder(scroller, "Input Frames"));
        mainBox.add(Box.createVerticalStrut(5));
        this.namingPanel_ = new NamingPanel(productDirPath);
        mainBox.add(this.namingPanel_);
        this.headingBox_ = new Box(0);
        this.add((Component)this.headingBox_, "North");
        this.controlBox_ = new Box(0);
        this.add((Component)this.controlBox_, "South");
    }

    public Request getRequest() {
        this.stopEditing();
        return this.request_;
    }

    public void stopEditing() {
        RequestPanel.stopEditing(this.paramTable_);
        RequestPanel.stopEditing(this.inFrameTable_);
    }

    private static void stopEditing(JTable table) {
        int row = table.getEditingRow();
        int col = table.getEditingColumn();
        if (row != -1 && col != -1) {
            table.getCellEditor(row, col).stopCellEditing();
        }
    }

    public void setRequest(Request request) {
        this.stopEditing();
        this.request_ = request;
        ParameterTableModel paramModel = new ParameterTableModel(this.request_.getParameters());
        this.paramTable_.setModel(paramModel);
        MarkedFrameTableModel frameModel = new MarkedFrameTableModel(this.request_.getInputFrames());
        this.inFrameTable_.setModel(frameModel);
        if (this.request_.getNamingScheme() == null) {
            this.request_.setNamingScheme(NamingScheme.DEFAULT);
        }
        this.namingPanel_.setRequest(this.request_);
    }

    public void addInputFrames(FrameList addedFrames) {
        if (this.isLocked() || this.request_ == null) {
            return;
        }
        MarkedFrameList frames = this.request_.getInputFrames();
        frames.addAll(addedFrames);
        ((AbstractTableModel)this.inFrameTable_.getModel()).fireTableDataChanged();
    }

    public void removeSelectedInputFrame() {
        this.removeInputFrame(this.inFrameTable_.getSelectedRow());
    }

    public void removeInputFrame(int row) {
        if (this.isLocked() || this.request_ == null || this.request_.getInputFrames().size() == 0) {
            return;
        }
        if (row < 0) {
            row = 0;
        }
        if (row >= this.request_.getInputFrames().size()) {
            row = this.request_.getInputFrames().size() - 1;
        }
        this.request_.getInputFrames().remove(row);
        ((AbstractTableModel)this.inFrameTable_.getModel()).fireTableDataChanged();
    }

    public void setLocked(boolean locked) {
        this.paramTable_.setLocked(locked);
        this.inFrameTable_.setLocked(locked);
        this.namingPanel_.setLocked(locked);
    }

    public JComponent getHeadingBox() {
        return this.headingBox_;
    }

    public JComponent getControlBox() {
        return this.controlBox_;
    }

    public boolean isLocked() {
        return this.isLocked_;
    }

    private static class LockableTable
    extends DataColumnTable {
        boolean isLocked_ = false;

        private LockableTable() {
        }

        public void setLocked(boolean locked) {
            boolean change = locked != this.isLocked_;
            this.isLocked_ = locked;
            TableModel model = this.getModel();
            if (change && model instanceof AbstractTableModel) {
                ((AbstractTableModel)model).fireTableDataChanged();
            }
        }

        @Override
        public boolean isCellEditable(int irow, int icol) {
            return !this.isLocked_ && super.isCellEditable(irow, icol);
        }

        public boolean isLocked() {
            return this.isLocked_;
        }
    }
}

