/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;

public class RangeConstraint
implements ParameterConstraint {
    private ParameterType type_;
    private Comparable min_;
    private Comparable max_;
    private String descrip_;

    public RangeConstraint(ParameterType type, Object min, Object max) throws ParameterValueException {
        Class tclass = type.getValueClass();
        if (!Comparable.class.isAssignableFrom(tclass)) {
            throw new IllegalArgumentException("Type " + type + " not comparable");
        }
        if (!tclass.isAssignableFrom(min.getClass())) {
            throw new IllegalArgumentException("min not of class " + tclass);
        }
        if (!tclass.isAssignableFrom(max.getClass())) {
            throw new IllegalArgumentException("max not of class " + tclass);
        }
        this.type_ = type;
        this.min_ = (Comparable)min;
        this.max_ = (Comparable)max;
        this.descrip_ = this.min_ + " <= val <= " + this.max_;
    }

    @Override
    public void checkValue(Object val) throws ParameterValueException {
        Class tclass = this.type_.getValueClass();
        if (!tclass.isAssignableFrom(val.getClass())) {
            throw new IllegalArgumentException("value not of class " + tclass);
        }
        Comparable cval = (Comparable)val;
        if (cval.compareTo(this.min_) < 0) {
            throw new ParameterValueException("Value " + cval + " < " + this.min_);
        }
        if (cval.compareTo(this.max_) > 0) {
            throw new ParameterValueException("Value " + cval + " > " + this.max_);
        }
    }

    public Comparable getMinimum() {
        return this.min_;
    }

    public Comparable getMaximum() {
        return this.max_;
    }

    @Override
    public String getDescription() {
        return this.descrip_;
    }
}

