/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eso.cpl.ParameterValueException;

public abstract class ParameterType {
    private String name_;
    private Class clazz_;
    public static ParameterType BOOL = new ParameterType("bool", Boolean.class){
        String[] trueStrings_ = new String[]{"true", "yes", "1", "t"};
        String[] falseStrings_ = new String[]{"false", "no", "0", "f"};
        Set trueValues_ = new HashSet<String>(Arrays.asList(this.trueStrings_));
        Set falseValues_ = new HashSet<String>(Arrays.asList(this.falseStrings_));

        @Override
        public Object fromString(String str) throws ParameterValueException {
            if (this.trueValues_.contains(str = str.toLowerCase())) {
                return Boolean.TRUE;
            }
            if (this.falseValues_.contains(str)) {
                return Boolean.FALSE;
            }
            throw new ParameterValueException(str + " not a recognized boolean");
        }
    };
    public static ParameterType INT = new ParameterType("int", Integer.class){

        @Override
        public Object fromString(String str) throws ParameterValueException {
            try {
                return Integer.valueOf(str);
            }
            catch (NumberFormatException e2) {
                throw new ParameterValueException(str + " not a recognised " + "integer", e2);
            }
        }
    };
    public static ParameterType DOUBLE = new ParameterType("double", Double.class){

        @Override
        public Object fromString(String str) throws ParameterValueException {
            try {
                return Double.valueOf(str);
            }
            catch (NumberFormatException e2) {
                throw new ParameterValueException(str + " not a recognised " + "double", e2);
            }
        }
    };
    public static ParameterType STRING = new ParameterType("string", String.class){

        @Override
        public Object fromString(String str) {
            return str;
        }
    };
    public static final List ALL_TYPES = Collections.unmodifiableList(Arrays.asList(BOOL, INT, DOUBLE, STRING));

    private ParameterType(String name, Class clazz) {
        this.name_ = name;
        this.clazz_ = clazz;
    }

    public String getName() {
        return this.name_;
    }

    public Class getValueClass() {
        return this.clazz_;
    }

    public String toString(Object value) {
        return value.toString();
    }

    public String toString() {
        return this.getName();
    }

    public abstract Object fromString(String var1) throws ParameterValueException;
}

