/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterImp;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;

public class Parameter {
    private final ParameterImp impl_;
    private final String context_;
    private final String help_;
    private final String name_;
    private final String tag_;
    private final ParameterType type_;
    private final ParameterConstraint constraint_;
    private final Object default_;
    private Object value_;

    public Parameter(ParameterImp impl) throws ParameterValueException {
        this.impl_ = impl;
        this.context_ = impl.getContext();
        this.help_ = impl.getHelp();
        this.name_ = impl.getName();
        this.tag_ = impl.getTag();
        this.type_ = impl.getType();
        this.constraint_ = impl.getConstraint();
        this.default_ = impl.getInitialValue();
        this.setValue(this.default_);
    }

    public ParameterImp getImp() {
        return this.impl_;
    }

    public String getContext() {
        return this.context_;
    }

    public Object getDefault() {
        return this.default_;
    }

    public String getHelp() {
        return this.help_;
    }

    public String getName() {
        return this.name_;
    }

    public String getTag() {
        return this.tag_;
    }

    public ParameterType getType() {
        return this.type_;
    }

    public ParameterConstraint getConstraint() {
        return this.constraint_;
    }

    public Object getValue() {
        return this.value_;
    }

    public void setValue(Object val) throws ParameterValueException {
        Class vclass = this.type_.getValueClass();
        if (val == null && vclass == String.class) {
            val = "";
        }
        if (!vclass.isAssignableFrom(val.getClass())) {
            String msg = "Attempt to set " + this + " to non-" + vclass.getName() + " value " + val + " (" + val.getClass().getName() + ")";
            throw new ParameterValueException(msg);
        }
        if (this.constraint_ != null) {
            this.constraint_.checkValue(val);
        }
        this.value_ = val;
        this.impl_.setValue(val);
    }

    public void setValueFromString(String str) throws ParameterValueException {
        this.setValue(this.type_.fromString(str));
    }

    public String toString() {
        return new StringBuffer().append(this.getName()).append(" (").append(this.getType()).append(this.getConstraint() == null ? "" : ": " + this.getConstraint()).append(") = ").append(this.getValue()).toString();
    }
}

