/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;

public class DelegatingConnection
extends AbandonedTrace
implements Connection {
    protected Connection _conn = null;
    protected boolean _closed = false;

    public DelegatingConnection(Connection c2) {
        this._conn = c2;
    }

    public DelegatingConnection(Connection c2, AbandonedConfig config) {
        super(config);
        this._conn = c2;
    }

    public Connection getDelegate() {
        return this._conn;
    }

    public boolean equals(Object obj) {
        Connection delegate = this.getInnermostDelegate();
        if (delegate == null) {
            return false;
        }
        if (obj instanceof DelegatingConnection) {
            DelegatingConnection c2 = (DelegatingConnection)obj;
            return delegate.equals(c2.getInnermostDelegate());
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        Connection obj = this.getInnermostDelegate();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public Connection getInnermostDelegate() {
        Connection c2 = this._conn;
        while (c2 != null && c2 instanceof DelegatingConnection) {
            if (this != (c2 = ((DelegatingConnection)c2).getDelegate())) continue;
            return null;
        }
        return c2;
    }

    public void setDelegate(Connection c2) {
        this._conn = c2;
    }

    public void close() throws SQLException {
        this.passivate();
        this._conn.close();
    }

    protected void handleException(SQLException e2) throws SQLException {
        throw e2;
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement());
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(sql));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._conn.clearWarnings();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void commit() throws SQLException {
        this.checkOpen();
        try {
            this._conn.commit();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getAutoCommit();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getCatalog();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getMetaData();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getTransactionIsolation();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return -1;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getTypeMap();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getWarnings();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.isReadOnly();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return false;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.nativeSQL(sql);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        try {
            this._conn.rollback();
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setCatalog(catalog);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setReadOnly(readOnly);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setTransactionIsolation(level);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setTypeMap(map);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public boolean isClosed() throws SQLException {
        return this._closed || this._conn.isClosed();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            throw new SQLException("Connection is closed.");
        }
    }

    protected void activate() {
        this._closed = false;
        this.setLastUsed();
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate() throws SQLException {
        try {
            List statements = this.getTrace();
            if (statements != null) {
                Statement[] set = new Statement[statements.size()];
                statements.toArray(set);
                int i = 0;
                while (i < set.length) {
                    set[i].close();
                    ++i;
                }
                this.clearTrace();
            }
            this.setLastUsed(0L);
            if (this._conn instanceof DelegatingConnection) {
                ((DelegatingConnection)this._conn).passivate();
            }
            Object var5_4 = null;
            this._closed = true;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._closed = true;
            throw throwable;
        }
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getHoldability();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return 0;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setHoldability(holdability);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.setSavepoint();
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.setSavepoint(name);
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this._conn.rollback(savepoint);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this._conn.releaseSavepoint(savepoint);
        }
        catch (SQLException e2) {
            this.handleException(e2);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql, autoGeneratedKeys));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql, columnIndexes));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(sql, columnNames));
        }
        catch (SQLException e2) {
            this.handleException(e2);
            return null;
        }
    }
}

