/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.PaddingException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public class UndefinedData
extends Data {
    long byteSize;
    byte[] data;

    public UndefinedData(Header h) throws FitsException {
        int naxis = h.getIntValue("NAXIS");
        int size = naxis > 0 ? 1 : 0;
        int i = 0;
        while (i < naxis) {
            size *= h.getIntValue("NAXIS" + (i + 1));
            ++i;
        }
        size += h.getIntValue("PCOUNT");
        if (h.getIntValue("GCOUNT") > 1) {
            size *= h.getIntValue("GCOUNT");
        }
        this.data = new byte[size *= Math.abs(h.getIntValue("BITPIX") / 8)];
        this.byteSize = size;
    }

    public UndefinedData(Object x) {
        this.byteSize = ArrayFuncs.computeLSize(x);
        this.data = new byte[(int)this.byteSize];
    }

    @Override
    protected void fillHeader(Header head) {
        try {
            head.setXtension("UNKNOWN");
            head.setBitpix(8);
            head.setNaxes(1);
            head.addValue("NAXIS1", this.byteSize, "ntf::undefineddata:naxis1:1");
            head.addValue("PCOUNT", 0L, "ntf::undefineddata:pcount:1");
            head.addValue("GCOUNT", 1L, "ntf::undefineddata:gcount:1");
            head.addValue("EXTEND", true, "ntf::undefineddata:extend:1");
        }
        catch (HeaderCardException e2) {
            System.err.println("Unable to create unknown header:" + e2);
        }
    }

    @Override
    public void read(ArrayDataInput i) throws FitsException {
        this.setFileOffset(i);
        if (i instanceof RandomAccess) {
            try {
                i.skipBytes(this.byteSize);
            }
            catch (IOException e2) {
                throw new FitsException("Unable to skip over data:" + e2);
            }
        }
        try {
            i.readFully(this.data);
        }
        catch (IOException e3) {
            throw new FitsException("Unable to read unknown data:" + e3);
        }
        int pad = FitsUtil.padding(this.getTrueSize());
        try {
            i.skipBytes(pad);
        }
        catch (EOFException e4) {
            throw new PaddingException("EOF skipping padding in undefined data", this);
        }
        catch (IOException e5) {
            throw new FitsException("Error skipping padding in undefined data");
        }
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        if (this.data == null) {
            this.getData();
        }
        if (this.data == null) {
            throw new FitsException("Null unknown data");
        }
        try {
            o.write(this.data);
        }
        catch (IOException e2) {
            throw new FitsException("IO Error on unknown data write" + e2);
        }
        FitsUtil.pad(o, this.getTrueSize());
    }

    @Override
    protected long getTrueSize() {
        return this.byteSize;
    }

    @Override
    public Object getData() {
        if (this.data == null) {
            try {
                FitsUtil.reposition(this.input, this.fileOffset);
                this.input.read(this.data);
            }
            catch (Exception e2) {
                return null;
            }
        }
        return this.data;
    }
}

