/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.RandomAccess;

public class FitsHeap
implements FitsElement {
    private byte[] heap = null;
    private int heapSize;
    private long fileOffset = -1L;
    private boolean expanded = false;
    private ArrayDataInput input;
    private int heapOffset = 0;
    private BufferedDataInputStream bstr;

    FitsHeap(int size) {
        this.heapSize = size;
    }

    @Override
    public void read(ArrayDataInput str) throws FitsException {
        if (this.heap == null) {
            this.heap = new byte[this.heapSize];
        }
        if (str instanceof RandomAccess) {
            this.fileOffset = FitsUtil.findOffset(str);
            this.input = str;
        }
        if (this.heap != null) {
            try {
                str.read(this.heap, 0, this.heapSize);
            }
            catch (IOException e2) {
                throw new FitsException("Error reading heap:" + e2);
            }
        }
        this.bstr = null;
    }

    @Override
    public void write(ArrayDataOutput str) throws FitsException {
        try {
            if (this.heap == null) {
                this.heap = new byte[this.heapSize];
            }
            str.write(this.heap, 0, this.heapSize);
        }
        catch (IOException e2) {
            throw new FitsException("Error writing heap:" + e2);
        }
    }

    @Override
    public boolean rewriteable() {
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput && !this.expanded;
    }

    @Override
    public void rewrite() throws IOException, FitsException {
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite FitsHeap");
        }
        ArrayDataOutput str = (ArrayDataOutput)((Object)this.input);
        FitsUtil.reposition(str, this.fileOffset);
        this.write(str);
    }

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.input, this.fileOffset);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public void getData(int offset, Object array) throws FitsException {
        try {
            if (this.heap == null) {
                this.heap = new byte[this.heapSize];
            }
            if (this.bstr == null || this.heapOffset > offset) {
                this.heapOffset = 0;
                this.bstr = new BufferedDataInputStream(new ByteArrayInputStream(this.heap));
            }
            this.bstr.skipBytes(offset - this.heapOffset);
            this.heapOffset = offset;
            this.heapOffset = (int)((long)this.heapOffset + this.bstr.readLArray(array));
        }
        catch (IOException e2) {
            throw new FitsException("Error decoding heap area at offset=" + offset + ".  Exception: Exception " + e2);
        }
    }

    void expandHeap(int need) {
        if (this.heap == null) {
            this.heap = new byte[this.heapSize];
        }
        this.bstr = null;
        if (this.heapSize + need > this.heap.length) {
            this.expanded = true;
            int newlen = (this.heapSize + need) * 2;
            if (newlen < 16384) {
                newlen = 16384;
            }
            byte[] newHeap = new byte[newlen];
            System.arraycopy(this.heap, 0, newHeap, 0, this.heapSize);
            this.heap = newHeap;
        }
    }

    int putData(Object data) throws FitsException {
        long lsize;
        if (this.heap == null) {
            this.heap = new byte[this.heapSize];
        }
        if ((lsize = ArrayFuncs.computeLSize(data)) > Integer.MAX_VALUE) {
            throw new FitsException("FITS Heap > 2 G");
        }
        int size = (int)lsize;
        this.expandHeap(size);
        ByteArrayOutputStream bo = new ByteArrayOutputStream(size);
        try {
            BufferedDataOutputStream o = new BufferedDataOutputStream(bo);
            o.writeArray(data);
            o.flush();
            o.close();
        }
        catch (IOException e2) {
            throw new FitsException("Unable to write variable column length data");
        }
        System.arraycopy(bo.toByteArray(), 0, this.heap, this.heapSize, size);
        int oldOffset = this.heapSize;
        this.heapSize += size;
        return oldOffset;
    }

    public int size() {
        return this.heapSize;
    }

    @Override
    public long getSize() {
        return this.size();
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }
}

