/*
 * Decompiled with CFR 0.152.
 */
package jal.CHAR;

import jal.CHAR.BinaryOperator;

public final class Numeric {
    public static char accumulate(char[] cArray, int n, int n2, char c2) {
        char c3 = c2;
        while (n < n2) {
            c3 = (char)(c3 + cArray[n++]);
        }
        return c3;
    }

    public static char accumulate(char[] cArray, int n, int n2, char c2, BinaryOperator binaryOperator) {
        char c3 = c2;
        while (n < n2) {
            c3 = binaryOperator.apply(c3, cArray[n++]);
        }
        return c3;
    }

    public static char inner_product(char[] cArray, char[] cArray2, int n, int n2, int n3, char c2) {
        char c3 = c2;
        while (n < n2) {
            c3 = (char)(c3 + cArray[n++] * cArray2[n3++]);
        }
        return c3;
    }

    public static char inner_product(char[] cArray, char[] cArray2, int n, int n2, int n3, char c2, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        char c3 = c2;
        while (n < n2) {
            c3 = binaryOperator.apply(c3, binaryOperator2.apply(cArray[n++], cArray2[n3++]));
        }
        return c3;
    }

    public static int partial_sum(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (n < n2) {
            cArray2[n3] = cArray[n];
            char c2 = cArray2[n3];
            while (++n < n2) {
                c2 = (char)(c2 + cArray[n]);
                cArray2[++n3] = c2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(char[] cArray, char[] cArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            cArray2[n3] = cArray[n];
            char c2 = cArray2[n3];
            while (++n < n2) {
                c2 = binaryOperator.apply(c2, cArray[n]);
                cArray2[++n3] = c2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(char[] cArray, char[] cArray2, int n, int n2, int n3) {
        if (n < n2) {
            cArray2[n3] = cArray[n];
            char c2 = cArray[n];
            while (++n < n2) {
                char c3 = cArray[n];
                cArray2[++n3] = (char)(c3 - c2);
                c2 = c3;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(char[] cArray, char[] cArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            cArray2[n3] = cArray[n];
            char c2 = cArray[n];
            while (++n < n2) {
                char c3 = cArray[n];
                cArray2[++n3] = binaryOperator.apply(c3, c2);
                c2 = c3;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

