/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.tds;

import com.sybase.jdbc3.jdbc.CharsetToUniInputStream;
import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.DynamicClassLoader;
import com.sybase.jdbc3.jdbc.DynamicObjectInputStream;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.RawInputStream;
import com.sybase.jdbc3.jdbc.RawToAsciiInputStream;
import com.sybase.jdbc3.jdbc.TextPointer;
import com.sybase.jdbc3.jdbc.UnicharToAsciiInputStream;
import com.sybase.jdbc3.jdbc.UnicharToUniInputStream;
import com.sybase.jdbc3.tds.CachedTdsJdbcInputStream;
import com.sybase.jdbc3.tds.Tds;
import com.sybase.jdbc3.tds.TdsDataObject;
import com.sybase.jdbc3.tds.TdsProtocolContext;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.CacheStream;
import com.sybase.jdbc3.utils.Cacheable;
import com.sybase.jdbc3.utils.HexConverts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TdsJdbcInputStream
extends TdsDataObject
implements Cacheable {
    private static final String case = "java.lang.Boolean";
    private static final String char = "java.lang.Double";
    private static final String void = "java.lang.Float";
    private static final String j = "java.lang.Integer";
    private static final String k = "java.lang.Long";
    private static final String else = "java.lang.Object";
    private static final String long = "java.lang.String";
    private static final String g = "java.math.BigDecimal";
    private static final String h = "java.io.FilterInputStream";
    private static final String b = "java.sql.Timestamp";
    private static final String d = "java.sql.Time";
    private static final String null = "java.sql.Date";
    private static final int goto = 512;
    public static final int RAW_TO_ASCII_STREAM = 1;
    public static final int RAW_TO_UNI_STREAM = 2;
    public static final int CHARSET_TO_UNI_STREAM = 3;
    public static final int RAW_STREAM = 4;
    public static final int UNITYPE_TO_UNI_STREAM = 5;
    public static final int UNITYPE_TO_ASCII_STREAM = 6;
    private CacheManager c;
    private RawInputStream f;
    private InputStreamReader i;
    private DynamicClassLoader e;

    public TdsJdbcInputStream(TdsProtocolContext tdsProtocolContext, Tds tds) throws IOException {
        super(tdsProtocolContext);
        this.e = this._tds.getClassLoader();
    }

    protected TdsDataObject createCachedCopy() throws SQLException, IOException {
        return new CachedTdsJdbcInputStream(this);
    }

    public InputStream getAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 3: {
                                this.f = this.makeNewRIS(4);
                                return this.f;
                            }
                            case 4: {
                                this.f = this.makeNewRIS(1);
                                return this.f;
                            }
                            case 5: {
                                this.f = this.makeNewRIS(6);
                                return this.f;
                            }
                        }
                        ErrorMessage.raiseError("JZ0TC");
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this.f = this.makeNewRIS(4);
                        return this.f;
                    }
                    case 34: 
                    case 37: 
                    case 45: {
                        this.f = this.makeNewRIS(1);
                        return this.f;
                    }
                    case 174: 
                    case 225: {
                        this.f = this._dataFmt.isUnitype() ? this.makeNewRIS(6) : this.makeNewRIS(1);
                        return this.f;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, unitext, image, binary, long binary, varbinary");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public Reader getCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 3: {
                                this.f = this.makeNewRIS(4);
                                this.i = new InputStreamReader((InputStream)this.f, this._tds._charsetName);
                                return this.i;
                            }
                            case 4: {
                                this.f = this.makeNewRIS(1);
                                this.i = new InputStreamReader((InputStream)this.f, this._tds._charsetName);
                                return this.i;
                            }
                            case 5: {
                                this.f = this.makeNewRIS(5);
                                String string = null;
                                string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                                this.i = new InputStreamReader((InputStream)this.f, string);
                                return this.i;
                            }
                        }
                        ErrorMessage.raiseError("JZ0TC");
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this.f = this.makeNewRIS(4);
                        this.i = new InputStreamReader((InputStream)this.f, this._tds._charsetName);
                        return this.i;
                    }
                    case 34: 
                    case 37: 
                    case 45: {
                        this.f = this.makeNewRIS(1);
                        this.i = new InputStreamReader((InputStream)this.f, this._tds._charsetName);
                        return this.i;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            this.f = this.makeNewRIS(5);
                            String string = null;
                            string = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            this.i = new InputStreamReader((InputStream)this.f, string);
                        } else {
                            this.f = this.makeNewRIS(1);
                            this.i = new InputStreamReader((InputStream)this.f, this._tds._charsetName);
                        }
                        return this.i;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TC");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return reader;
    }

    public InputStream getUnicodeStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        switch (this._dataFmt._blobType) {
                            case 3: {
                                this.f = this.makeNewRIS(3);
                                return this.f;
                            }
                            case 4: {
                                this.f = this.makeNewRIS(2);
                                return this.f;
                            }
                            case 5: {
                                this.f = this.makeNewRIS(5);
                                return this.f;
                            }
                        }
                        ErrorMessage.raiseError("JZ0TC");
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        this.f = this.makeNewRIS(3);
                        return this.f;
                    }
                    case 34: 
                    case 37: 
                    case 45: {
                        this.f = this.makeNewRIS(2);
                        return this.f;
                    }
                    case 174: 
                    case 225: {
                        this.f = this._dataFmt.isUnitype() ? this.makeNewRIS(5) : this.makeNewRIS(2);
                        return this.f;
                    }
                    default: {
                        ErrorMessage.raiseError("JZ0TE", "char, varchar, unichar, univarchar, text, unitext, image, binary, long binary, varbinary");
                    }
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    public InputStream getBinaryStream() throws SQLException {
        InputStream inputStream = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 36: {
                        if (this._dataFmt._blobType != 4) {
                            ErrorMessage.raiseError("JZ0TC");
                        }
                    }
                    case 34: 
                    case 37: 
                    case 45: 
                    case 225: {
                        this.f = this.makeNewRIS(4);
                        return this.f;
                    }
                }
                ErrorMessage.raiseError("JZ0TE", "image, binary, long binary, varbinary");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        bigDecimal = new BigDecimal((double)this.readUnsignedByte());
                        break;
                    }
                    case 52: {
                        bigDecimal = new BigDecimal((double)this.readShort());
                        break;
                    }
                    case 65: {
                        bigDecimal = new BigDecimal((double)this.readUnsignedShortAsInt());
                        break;
                    }
                    case 56: {
                        bigDecimal = new BigDecimal((double)this.readInt());
                        break;
                    }
                    case 66: {
                        bigDecimal = new BigDecimal((double)this.readUnsignedIntAsLong());
                        break;
                    }
                    case 191: {
                        bigDecimal = new BigDecimal((double)this.readLong());
                        break;
                    }
                    case 67: {
                        bigDecimal = this.readUnsignedLongAsBigDecimal();
                        break;
                    }
                    case 38: {
                        bigDecimal = new BigDecimal((double)this.readINTN());
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            bigDecimal = new BigDecimal((double)this.readUINTN());
                            break;
                        }
                        bigDecimal = this.readUnsignedLongAsBigDecimal();
                        break;
                    }
                    case 59: {
                        bigDecimal = new BigDecimal(this.readFloat());
                        break;
                    }
                    case 62: {
                        bigDecimal = new BigDecimal(this.readDouble());
                        break;
                    }
                    case 109: {
                        bigDecimal = new BigDecimal(this.readFLTN());
                        break;
                    }
                    case 106: 
                    case 108: {
                        bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        bigDecimal = new BigDecimal(Convert.numString(this.readString()));
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            bigDecimal = new BigDecimal(Convert.numString(this.readUnicodeString()));
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        bigDecimal = this.readMONEYN();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        bigDecimal = Convert.setScale(bigDecimal, n);
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        bl = 0 != this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        bl = 0 != this.readShort();
                        break;
                    }
                    case 65: {
                        bl = 0 != this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        bl = 0 != this.readInt();
                        break;
                    }
                    case 66: {
                        bl = 0L != this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        bl = 0L != this.readLong();
                        break;
                    }
                    case 67: {
                        bl = 0L != this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 38: {
                        bl = 0L != this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            bl = 0L != this.readUINTN();
                            break;
                        }
                        bl = 0L != this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        BigDecimal bigDecimal = this.readMONEYN();
                        bl = 0 != bigDecimal.signum();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        bl = 0.0 != this.readFLTN();
                        break;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        bl = 0 != bigDecimal.signum();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        String string = this.readString();
                        bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            String string = this.readUnicodeString();
                            bl = string != null && (string.trim().toLowerCase().equals("true") || string.trim().equals("1"));
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money, unsigned bigint");
                }
                Convert.checkByteOflo(l);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (byte)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getBytes() throws SQLException {
        byte[] byArray = null;
        try {
            this.beginRead();
            if (this._isNull) return byArray;
            switch (this._dataFmt._datatype) {
                case 36: {
                    int n;
                    if (this._dataFmt._blobType != 4) {
                        ErrorMessage.raiseError("JZ0TE", "Object");
                    }
                    this.f = this.makeNewRIS(4);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[512];
                    while ((n = this.f.read(byArray2, 0, 512)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    this.f.close();
                    this.f = null;
                    return byArray;
                }
                case 34: 
                case 37: 
                case 45: 
                case 174: 
                case 225: {
                    byArray = this.funkyBinaryReader();
                    return byArray;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TE", "varbinay, long binary, binary, image, unitext");
                    return byArray;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return byArray;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getRawBytes() throws SQLException {
        byte[] byArray = null;
        try {
            this.beginRead();
            if (!this._isNull) {
                int n;
                this.f = this.makeNewRIS(4);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[512];
                while ((n = this.f.read(byArray2, 0, 512)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                this.f.close();
                this.f = null;
                this._dataLength = byArray.length;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        finally {
            this.endRead();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TextPointer getTextPtr() throws SQLException {
        byte[] byArray;
        block17: {
            block16: {
                this.beginRead();
                if (!this._isNull) {
                    switch (this._dataFmt._datatype) {
                        case 34: 
                        case 35: 
                        case 174: {
                            break;
                        }
                        default: {
                            ErrorMessage.raiseError("JZ0R4");
                            break;
                        }
                    }
                    break block16;
                }
                ErrorMessage.raiseError("JZ0R4");
            }
            byArray = null;
            this.endRead();
            try {
                if (this._dataFmt._datatype == 34) {
                    this.funkyBinaryReader();
                    break block17;
                }
                String string = this.readString();
            }
            catch (IOException iOException) {}
            break block17;
            {
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                    byArray = null;
                    this.endRead();
                    try {
                        if (this._dataFmt._datatype == 34) {
                            this.funkyBinaryReader();
                            break block17;
                        }
                        String string = this.readString();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.endRead();
                try {
                    if (this._dataFmt._datatype == 34) {
                        this.funkyBinaryReader();
                    } else {
                        String string = this.readString();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        TextPointer textPointer = new TextPointer(this._context);
        byte[] byArray2 = new byte[this._textptrlen];
        byArray = new byte[8];
        System.arraycopy(this._textptr, 0, byArray2, 0, this._textptrlen);
        System.arraycopy(this._textptr, this._textptrlen, byArray, 0, 8);
        textPointer._textPtr = byArray2;
        textPointer._timeStamp = byArray;
        textPointer._tableName = this._dataFmt._tableName;
        textPointer._columnName = this._dataFmt.getName();
        return textPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateObject getDateObject(int n, Calendar calendar) throws SQLException {
        DateObject dateObject = null;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        dateObject = Convert.objectToDateObject(this.readString(), n, calendar);
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            dateObject = Convert.objectToDateObject(this.readUnicodeString(), n, calendar);
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 58: 
                    case 61: 
                    case 111: {
                        dateObject = this.readDATETIMN().dateObjectValue(calendar);
                        break;
                    }
                    case 49: 
                    case 123: {
                        if (n == 92) {
                            ErrorMessage.raiseError("JZ0TI", "date", "time");
                            break;
                        }
                        dateObject = this.readDATEN().dateObjectValue(calendar);
                        break;
                    }
                    case 51: 
                    case 147: {
                        if (n == 91) {
                            ErrorMessage.raiseError("JZ0TI", "time", "date");
                            break;
                        }
                        dateObject = this.readTIMEN().dateObjectValue(calendar);
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "char, unichar, varchar, univarchar, text, unitext, datetime, short datetime, date, time");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorMessage.raiseError("JZ009", illegalArgumentException.getMessage());
        }
        finally {
            this.endRead();
        }
        return dateObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble() throws SQLException {
        double d2 = 0.0;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        d2 = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        d2 = this.readShort();
                        break;
                    }
                    case 65: {
                        d2 = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        d2 = this.readInt();
                        break;
                    }
                    case 66: {
                        d2 = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        d2 = this.readLong();
                        break;
                    }
                    case 67: {
                        d2 = this.readUnsignedLongAsBigDecimal().doubleValue();
                        break;
                    }
                    case 38: {
                        d2 = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            d2 = this.readINTN();
                            break;
                        }
                        d2 = this.readUnsignedLongAsBigDecimal().doubleValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        d2 = this.readFLTN();
                        break;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        if (bigDecimal == null) break;
                        d2 = bigDecimal.doubleValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        d2 = Double.valueOf(Convert.numString(this.readString()));
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            d2 = Double.valueOf(Convert.numString(this.readUnicodeString()));
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        BigDecimal bigDecimal = this.readMONEYN();
                        if (bigDecimal == null) break;
                        d2 = bigDecimal.doubleValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat() throws SQLException {
        float f = 0.0f;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        f = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        f = this.readShort();
                        break;
                    }
                    case 65: {
                        f = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        f = this.readInt();
                        break;
                    }
                    case 66: {
                        f = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        f = this.readLong();
                        break;
                    }
                    case 38: {
                        f = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            f = this.readUINTN();
                            break;
                        }
                        f = this.readUnsignedLongAsBigDecimal().floatValue();
                        break;
                    }
                    case 59: {
                        f = this.readFloat();
                        break;
                    }
                    case 62: {
                        f = (float)this.readDouble();
                        break;
                    }
                    case 109: {
                        f = (float)this.readFLTN();
                        break;
                    }
                    case 106: 
                    case 108: {
                        BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                        if (bigDecimal == null) break;
                        f = bigDecimal.floatValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        f = Float.valueOf(Convert.numString(this.readString())).floatValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            f = Float.valueOf(Convert.numString(this.readUnicodeString())).floatValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        BigDecimal bigDecimal = this.readMONEYN();
                        if (bigDecimal == null) break;
                        f = bigDecimal.floatValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money, unsigned bigint");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money,unsigned bigint");
                }
                Convert.checkIntOflo(l);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (int)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext,  money, short money, unsigned bigint");
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject() throws SQLException {
        Object object = null;
        try {
            this.beginRead();
            if (this._isNull) return object;
            switch (this._dataFmt._datatype) {
                case 50: {
                    int n = this.readUnsignedByte();
                    object = new Boolean(n != 0);
                    return object;
                }
                case 48: {
                    object = new Integer((byte)this.readUnsignedByte());
                    return object;
                }
                case 52: {
                    object = new Integer(this.readShort());
                    return object;
                }
                case 65: {
                    object = new Integer(this.readUnsignedShortAsInt());
                    return object;
                }
                case 56: {
                    object = new Integer(this.readInt());
                    return object;
                }
                case 66: {
                    object = new Long(this.readUnsignedIntAsLong());
                    return object;
                }
                case 191: {
                    object = new Long(this.readLong());
                    return object;
                }
                case 67: {
                    object = this.readUnsignedLongAsBigDecimal();
                    return object;
                }
                case 38: {
                    if (this._dataLength <= 4) {
                        object = new Integer((int)this.readINTN());
                        return object;
                    } else {
                        object = new Long(this.readINTN());
                        return object;
                    }
                }
                case 68: {
                    if (this._dataLength < 8) {
                        object = new Integer((int)this.readUINTN());
                        return object;
                    } else {
                        object = this.readUnsignedLongAsBigDecimal();
                        return object;
                    }
                }
                case 59: {
                    object = new Float(this.readFloat());
                    return object;
                }
                case 62: 
                case 109: {
                    if (this._dataLength == 4) {
                        object = new Float(this.readFloat());
                        return object;
                    } else {
                        object = new Double(this.readFLTN());
                        return object;
                    }
                }
                case 106: 
                case 108: {
                    object = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    return object;
                }
                case 39: 
                case 47: {
                    object = this.readString();
                    return object;
                }
                case 60: 
                case 110: 
                case 122: {
                    object = this.readMONEYN();
                    return object;
                }
                case 37: 
                case 45: 
                case 225: {
                    if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                        object = this.readUnicodeString();
                        return object;
                    }
                }
                case 34: {
                    object = this.funkyBinaryReader();
                    return object;
                }
                case 35: 
                case 175: {
                    object = this.readString();
                    return object;
                }
                case 174: {
                    object = this.readUnicodeString();
                    return object;
                }
                case 58: 
                case 61: 
                case 111: {
                    object = Convert.objectToTimestamp(this.readDATETIMN().dateObjectValue());
                    return object;
                }
                case 49: 
                case 123: {
                    object = Convert.objectToDate(this.readDATEN().dateObjectValue());
                    return object;
                }
                case 51: 
                case 147: {
                    object = Convert.objectToTime(this.readTIMEN().dateObjectValue());
                    return object;
                }
                case 103: 
                case 104: {
                    byte[] byArray = new byte[this._dataLength];
                    this.in.read(byArray, 0, this._dataLength);
                    object = byArray;
                    return object;
                }
                case 36: {
                    switch (this._dataFmt._blobType) {
                        case 1: {
                            object = this.a();
                            return object;
                        }
                        case 3: {
                            this.f = this.makeNewRIS(3);
                            object = this.f;
                            return object;
                        }
                        case 5: {
                            this.f = this.makeNewRIS(5);
                            object = this.f;
                            return object;
                        }
                        case 4: {
                            this.f = this.makeNewRIS(4);
                            object = this.f;
                            return object;
                        }
                    }
                    return object;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return object;
        }
        finally {
            if (this.f == null) {
                this.endRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort() throws SQLException {
        long l = 0L;
        boolean bl = false;
        try {
            this.beginRead();
            if (!this._isNull) {
                switch (this._dataFmt._datatype) {
                    case 48: 
                    case 50: {
                        l = this.readUnsignedByte();
                        break;
                    }
                    case 52: {
                        l = this.readShort();
                        break;
                    }
                    case 65: {
                        l = this.readUnsignedShortAsInt();
                        break;
                    }
                    case 56: {
                        l = this.readInt();
                        break;
                    }
                    case 66: {
                        l = this.readUnsignedIntAsLong();
                        break;
                    }
                    case 191: {
                        l = this.readLong();
                        break;
                    }
                    case 38: {
                        l = this.readINTN();
                        break;
                    }
                    case 68: {
                        if (this._dataLength < 8) {
                            l = this.readUINTN();
                            break;
                        }
                        l = this.readUnsignedLongAsBigDecimal().longValue();
                        break;
                    }
                    case 59: 
                    case 62: 
                    case 109: {
                        l = new Double(this.readFLTN()).longValue();
                        break;
                    }
                    case 106: 
                    case 108: {
                        l = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale).longValue();
                        break;
                    }
                    case 35: 
                    case 39: 
                    case 47: 
                    case 175: {
                        l = new BigDecimal(Convert.numString(this.readString())).longValue();
                        break;
                    }
                    case 174: 
                    case 225: {
                        if (this._dataFmt.isUnitype()) {
                            l = new BigDecimal(Convert.numString(this.readUnicodeString())).longValue();
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 60: 
                    case 110: 
                    case 122: {
                        l = this.readMONEYN().longValue();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (bl) {
                    ErrorMessage.raiseError("JZ0TE", "tinyint, smallint, int, bit, float, decimal, numeric, char, unichar, varchar, univarchar, text, unitext, money, short money, unsigned bigint");
                }
                Convert.checkShortOflo(l);
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
        }
        finally {
            this.endRead();
        }
        return (short)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString() throws SQLException {
        String string = null;
        try {
            this.beginRead();
            if (this._isNull) return string;
            switch (this._dataFmt._datatype) {
                case 48: 
                case 50: {
                    string = String.valueOf(this.readUnsignedByte());
                    return string;
                }
                case 52: {
                    string = String.valueOf(this.readShort());
                    return string;
                }
                case 65: {
                    string = String.valueOf(this.readUnsignedShortAsInt());
                    return string;
                }
                case 56: {
                    string = String.valueOf(this.readInt());
                    return string;
                }
                case 66: {
                    string = String.valueOf(this.readUnsignedIntAsLong());
                    return string;
                }
                case 191: {
                    string = String.valueOf(this.readLong());
                    return string;
                }
                case 67: {
                    string = String.valueOf(this.readUnsignedLongAsBigDecimal());
                    return string;
                }
                case 38: {
                    string = String.valueOf(this.readINTN());
                    return string;
                }
                case 68: {
                    if (this._dataLength < 8) {
                        string = String.valueOf(this.readUINTN());
                        return string;
                    } else {
                        string = String.valueOf(this.readUnsignedLongAsBigDecimal());
                        return string;
                    }
                }
                case 59: {
                    string = String.valueOf(this.readFloat());
                    return string;
                }
                case 62: {
                    string = String.valueOf(this.readDouble());
                    return string;
                }
                case 109: {
                    string = String.valueOf(this.readFLTN());
                    return string;
                }
                case 106: 
                case 108: {
                    BigDecimal bigDecimal = this.readNUMERIC(this._dataFmt._precision, this._dataFmt._scale);
                    if (bigDecimal == null) return string;
                    string = bigDecimal.toString();
                    return string;
                }
                case 35: 
                case 39: 
                case 47: 
                case 175: {
                    string = this.readString();
                    return string;
                }
                case 34: 
                case 37: 
                case 45: 
                case 103: 
                case 104: {
                    if (this._holds0LNN) {
                        string = "";
                        return string;
                    } else {
                        string = HexConverts.hexConvert(this.funkyBinaryReader());
                        return string;
                    }
                }
                case 225: {
                    if (this._dataFmt._usertype == 35 || this._dataFmt._usertype == 34) {
                        string = this.readUnicodeString();
                        return string;
                    } else if (this._holds0LNN) {
                        string = "";
                        return string;
                    } else {
                        string = HexConverts.hexConvert(this.funkyBinaryReader());
                        return string;
                    }
                }
                case 174: {
                    string = this.readUnicodeString();
                    return string;
                }
                case 60: 
                case 110: 
                case 122: {
                    BigDecimal bigDecimal = this.readMONEYN();
                    if (bigDecimal == null) return string;
                    string = bigDecimal.toString();
                    return string;
                }
                case 58: 
                case 61: 
                case 111: {
                    string = this.readDATETIMN().stringValue();
                    return string;
                }
                case 49: 
                case 123: {
                    string = this.readDATEN().stringValue();
                    return string;
                }
                case 51: 
                case 147: {
                    string = this.readTIMEN().stringValue();
                    return string;
                }
                case 36: {
                    switch (this._dataFmt._blobType) {
                        case 1: {
                            Object object = this.a();
                            if (object == null) {
                                string = null;
                                return string;
                            } else {
                                string = object.toString();
                                return string;
                            }
                        }
                        case 3: {
                            int n;
                            this.f = this.makeNewRIS(4);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.f, this._tds._charsetName);
                            char[] cArray = new char[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                stringBuffer.append(cArray, 0, n);
                            }
                            string = stringBuffer.toString();
                            inputStreamReader.close();
                            this.f.close();
                            this.f = null;
                            return string;
                        }
                        case 5: {
                            int n;
                            this.f = this.makeNewRIS(5);
                            String string2 = null;
                            string2 = this.getBigEndian() ? "UnicodeBig" : "UnicodeLittle";
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.f, string2);
                            char[] cArray = new char[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n = inputStreamReader.read(cArray, 0, 512)) != -1) {
                                stringBuffer.append(cArray, 0, n);
                            }
                            string = stringBuffer.toString();
                            inputStreamReader.close();
                            this.f.close();
                            this.f = null;
                            return string;
                        }
                        case 4: {
                            int n;
                            this.f = this.makeNewRIS(4);
                            byte[] byArray = new byte[512];
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n = this.f.read(byArray, 0, 512)) != -1) {
                                stringBuffer.append(HexConverts.hexConvert(byArray, n));
                            }
                            string = stringBuffer.toString();
                            this.f.close();
                            this.f = null;
                            return string;
                        }
                    }
                    ErrorMessage.raiseError("JZ0TC");
                    return string;
                }
                default: {
                    ErrorMessage.raiseError("JZ0TC");
                    return string;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
            return string;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMessage.raiseError("JZ009", numberFormatException.toString());
            return string;
        }
        finally {
            this.endRead();
        }
    }

    public boolean isNull() throws SQLException {
        return this._isNull;
    }

    public void open(boolean bl) {
        this._state = bl ? 2 : 1;
        if (this._context._lastResult == 209) {
            this._context._lastResult = -1;
        }
    }

    public int getState() {
        return this._state;
    }

    public void setManager(CacheManager cacheManager) {
        this.c = cacheManager;
    }

    public void cache() throws IOException {
        int n;
        if (this._state == 3) {
            return;
        }
        if (this.c == null) {
            this.startRead();
            if (this._context._rereadable && (this._state == 0 || this.f == null)) {
                this.do();
            }
        }
        this._state = 2;
        if (this.f != null) {
            if (this._context._rereadable) {
                this.f.cache((CacheStream)this.in);
            } else {
                this.f.close();
                this.f = null;
            }
            this._state = 3;
            return;
        }
        this.getSize();
        if (this._dataLength == -1 && this.f == null) {
            try {
                this.f = this.makeNewRIS(4);
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            this.f.cache((CacheStream)this.in);
            this._state = 3;
            this.reset();
            this.f = null;
            return;
        }
        byte[] byArray = new byte[512];
        for (int i = this._dataLength; i > 0; i -= n) {
            n = i < 512 ? i : 512;
            this.in.read(byArray, 0, n);
        }
        if (this.c != null) {
            this.c.doneReading();
        }
        this._state = 3;
        if (this.c != null) {
            this.in.reset();
        }
    }

    public void clear() throws IOException {
        if (this.f != null) {
            this.f.close();
            this.f = null;
        } else {
            switch (this._state) {
                case 0: {
                    if (this.c != null) break;
                    this.if();
                    break;
                }
                case 1: {
                    this.if();
                    if (this.c == null) break;
                    this.c.doneReading();
                    break;
                }
                case 2: {
                    this.getSize();
                    this.in.skip(this._dataLength);
                    if (this.c == null) break;
                    this.c.doneReading();
                }
            }
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void if() throws IOException {
        this.getSize();
        if (this._dataLength == -1) {
            try {
                this.f = this.makeNewRIS(4);
                this.f.close();
            }
            catch (SQLException sQLException) {
                ErrorMessage.raiseIOECheckDead(sQLException);
            }
            finally {
                this.f = null;
            }
        } else {
            this.in.skip(this._dataLength);
        }
    }

    public void resetInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int available() throws IOException {
        return this._dataLength != -1 ? this._dataLength : this.in.available();
    }

    public void initialize() {
        super.initialize();
        this.f = null;
        if (this.in instanceof CacheStream) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = this._context._in;
        }
    }

    public void reset() throws IOException {
        if (this._state == 3 && !this._isNull) {
            this.in.reset();
            if (this.c != null) {
                this._dataLength = -2;
                this.getSize();
            }
        } else {
            ErrorMessage.raiseIOException("JZ0P7");
        }
    }

    protected void beginRead() throws IOException {
        if (this.c == null && this._state == 0 && this._prev != null && this._prev._state != 3) {
            this._prev.cache();
        }
        if (this.f != null) {
            if (this._context._rereadable) {
                this.f.cache((CacheStream)this.in);
                this._state = 3;
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
        this.getSize();
        if (this._isNull) {
            return;
        }
        if (this.c == null) {
            if (this._state == 0) {
                if (this._context._rereadable) {
                    this.do();
                }
                this._state = 1;
            }
        } else if (this._state == 0) {
            ErrorMessage.raiseIOException("JZ0R3");
        }
        if (this._state == 3) {
            if (this._context._rereadable) {
                this.reset();
            } else {
                ErrorMessage.raiseIOException("JZ0R3");
            }
        }
    }

    protected void endRead() throws SQLException {
        if (this._state != 3 && this.c != null) {
            this.c.doneReading();
        }
        this._state = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawInputStream makeNewRIS(int n) throws SQLException {
        if (this.f != null) {
            if (this._context._rereadable) {
                try {
                    this.f.close();
                    this._state = 3;
                    this.reset();
                }
                catch (IOException iOException) {
                    ErrorMessage.raiseErrorCheckDead(iOException);
                }
                finally {
                    this.f = null;
                }
            } else {
                ErrorMessage.raiseError("JZ0R3");
            }
        }
        RawInputStream rawInputStream = null;
        CacheManager cacheManager = null;
        int n2 = this._dataLength;
        if (this._dataFmt._datatype == 37 && this._dataFmt._usertype == 3) {
            n2 = this._dataFmt._length;
        }
        if (this._context._maxFieldSize > 0) {
            n2 = Math.min(n2, this._context._maxFieldSize);
        }
        if (this._state != 3) {
            cacheManager = this.c;
            this._state = 1;
        }
        try {
            switch (n) {
                case 4: {
                    rawInputStream = new RawInputStream(this, this._dataLength, n2, cacheManager);
                    break;
                }
                case 1: {
                    rawInputStream = new RawToAsciiInputStream(this, this._dataLength, n2, cacheManager);
                    break;
                }
                case 3: {
                    rawInputStream = new CharsetToUniInputStream(this, this._dataLength, n2, cacheManager, this._tds._charsetName);
                    break;
                }
                case 2: {
                    int n3 = this._dataLength == -1 ? -1 : 2 * this._dataLength;
                    int n4 = n2 == -1 ? -1 : 2 * n2;
                    rawInputStream = new CharsetToUniInputStream(new RawToAsciiInputStream(this, this._dataLength, n2, cacheManager), n3, n4, null, "ISO8859_1");
                    break;
                }
                case 5: {
                    if (this.getBigEndian()) {
                        rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n2, cacheManager, false);
                        break;
                    }
                    rawInputStream = new UnicharToUniInputStream((InputStream)this, this._dataLength, n2, cacheManager, true);
                    break;
                }
                case 6: {
                    if (n2 != this._dataLength) {
                        n2 = n2 * 2 < this._dataLength ? (n2 *= 2) : this._dataLength;
                    }
                    rawInputStream = new UnicharToAsciiInputStream(this, this._dataLength, n2, this.getBigEndian(), cacheManager);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZ0I5", iOException.toString());
        }
        rawInputStream.setCached(this._state == 3);
        return rawInputStream;
    }

    protected static String getObjectClassName(int n, int n2, int n3, int n4) throws SQLException {
        String string = else;
        switch (n) {
            case 50: {
                string = case;
                break;
            }
            case 48: 
            case 52: 
            case 56: 
            case 65: {
                string = j;
                break;
            }
            case 66: 
            case 191: {
                string = k;
                break;
            }
            case 67: {
                string = g;
                break;
            }
            case 68: {
                switch (n4) {
                    case 2: {
                        string = j;
                        break;
                    }
                    case 4: {
                        string = k;
                        break;
                    }
                    case 8: {
                        string = g;
                    }
                }
                break;
            }
            case 38: {
                if (n4 <= 4) {
                    string = j;
                    break;
                }
                string = k;
                break;
            }
            case 59: {
                string = void;
                break;
            }
            case 62: 
            case 109: {
                if (n4 == 4) {
                    string = void;
                    break;
                }
                string = char;
                break;
            }
            case 35: 
            case 39: 
            case 47: 
            case 174: 
            case 175: {
                string = long;
                break;
            }
            case 60: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                string = g;
                break;
            }
            case 34: 
            case 37: 
            case 45: 
            case 103: 
            case 104: {
                string = new byte[1].getClass().getName();
                break;
            }
            case 225: {
                if (n2 == 34 || n2 == 35) {
                    string = long;
                    break;
                }
                string = new byte[1].getClass().getName();
                break;
            }
            case 58: 
            case 61: 
            case 111: {
                string = b;
                break;
            }
            case 49: 
            case 123: {
                string = null;
                break;
            }
            case 51: 
            case 147: {
                string = d;
                break;
            }
            case 36: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        string = else;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = h;
                    }
                }
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0TC");
            }
        }
        return string;
    }

    private void do() {
        this.in = new CacheStream(this._context._cm, this.in, this._context._timeout);
    }

    private Object a() throws SQLException {
        Object object = null;
        try {
            this.f = this.makeNewRIS(4);
            if (this.f.available() > 0) {
                ObjectInputStream objectInputStream = this.e == null ? new ObjectInputStream(this.f) : new DynamicObjectInputStream((InputStream)this.f, this.e);
                object = objectInputStream.readObject();
                objectInputStream.close();
            } else {
                this._isNull = true;
            }
            this.f.close();
            this.f = null;
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ010", exception.getMessage());
        }
        return object;
    }
}

