/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.SelectedSparseObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix1D;

public class SparseObjectMatrix2D
extends ObjectMatrix2D {
    protected AbstractIntObjectMap elements;

    public SparseObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public SparseObjectMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix2D(int n, int n2, int n3, double d2, double d3) {
        this.setUp(n, n2);
        this.elements = new OpenIntObjectHashMap(n3, d2, d3);
    }

    protected SparseObjectMatrix2D(int n, int n2, AbstractIntObjectMap abstractIntObjectMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractIntObjectMap;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public Object getQuick(int n, int n2) {
        return this.elements.get(this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedSparseObjectMatrix2D) {
            SelectedSparseObjectMatrix2D selectedSparseObjectMatrix2D = (SelectedSparseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedSparseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof SparseObjectMatrix2D) {
            SparseObjectMatrix2D sparseObjectMatrix2D = (SparseObjectMatrix2D)objectMatrix2D;
            return this.elements == sparseObjectMatrix2D.elements;
        }
        return false;
    }

    protected int index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new SparseObjectMatrix1D(n);
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        return new SparseObjectMatrix1D(n, this.elements, n2, n3);
    }

    public void setQuick(int n, int n2, Object object) {
        int n3 = this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
        if (object == null) {
            this.elements.removeKey(n3);
        } else {
            this.elements.put(n3, object);
        }
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseObjectMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

