/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.WrapperDoubleMatrix2D;
import cern.jet.math.Functions;

class RCMDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private IntArrayList[] indexes;
    private DoubleArrayList[] values;

    public RCMDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public RCMDoubleMatrix2D(int n, int n2) {
        super(null);
        this.setUp(n, n2);
        this.indexes = new IntArrayList[n];
        this.values = new DoubleArrayList[n];
    }

    public DoubleMatrix2D assign(double d2) {
        if (d2 == 0.0) {
            int n = this.rows;
            while (--n >= 0) {
                this.indexes[n] = null;
                this.values[n] = null;
            }
        } else {
            super.assign(d2);
        }
        return this;
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    public double getQuick(int n, int n2) {
        int n3 = -1;
        if (this.indexes[n] != null) {
            n3 = this.indexes[n].binarySearch(n2);
        }
        if (n3 < 0) {
            return 0.0;
        }
        return this.values[n].getQuick(n3);
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new RCMDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public void setQuick(int n, int n2, double d2) {
        int n3 = n;
        int n4 = n2;
        int n5 = -1;
        IntArrayList intArrayList = this.indexes[n3];
        if (intArrayList != null) {
            n5 = intArrayList.binarySearch(n4);
        }
        if (n5 >= 0) {
            if (d2 == 0.0) {
                DoubleArrayList doubleArrayList = this.values[n3];
                intArrayList.remove(n5);
                doubleArrayList.remove(n5);
                int n6 = intArrayList.size();
                if (n6 > 2 && n6 * 3 < intArrayList.elements().length) {
                    intArrayList.setSize(n6 * 3 / 2);
                    intArrayList.trimToSize();
                    intArrayList.setSize(n6);
                    doubleArrayList.setSize(n6 * 3 / 2);
                    doubleArrayList.trimToSize();
                    doubleArrayList.setSize(n6);
                }
            } else {
                this.values[n3].setQuick(n5, d2);
            }
        } else {
            if (d2 == 0.0) {
                return;
            }
            n5 = -n5 - 1;
            if (intArrayList == null) {
                this.indexes[n3] = new IntArrayList(3);
                this.values[n3] = new DoubleArrayList(3);
            }
            this.indexes[n3].beforeInsert(n5, n4);
            this.values[n3].beforeInsert(n5, d2);
        }
    }

    protected void zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, IntArrayList intArrayList, DoubleMatrix1D[] doubleMatrix1DArray, double d2, double d3) {
        if (this.columns != doubleMatrix1D.size() || this.rows > doubleMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        doubleMatrix1D2.assign(Functions.mult(d3 / d2));
        int n = this.indexes.length;
        while (--n >= 0) {
            if (this.indexes[n] == null) continue;
            int n2 = this.indexes[n].size();
            while (--n2 >= 0) {
                int n3 = this.indexes[n].getQuick(n2);
                double d4 = this.values[n].getQuick(n2);
                doubleMatrix1D2.setQuick(n, doubleMatrix1D2.getQuick(n) + d4 * doubleMatrix1D.getQuick(n3));
            }
        }
        doubleMatrix1D2.assign(Functions.mult(d2));
    }
}

