/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.PersistentObject;
import cern.colt.map.PrimeFinder;

public abstract class AbstractMap
extends PersistentObject {
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;

    protected AbstractMap() {
    }

    protected int chooseGrowCapacity(int n, double d2, double d3) {
        return this.nextPrime(Math.max(n + 1, (int)((double)(4 * n) / (3.0 * d2 + d3))));
    }

    protected int chooseHighWaterMark(int n, double d2) {
        return Math.min(n - 2, (int)((double)n * d2));
    }

    protected int chooseLowWaterMark(int n, double d2) {
        return (int)((double)n * d2);
    }

    protected int chooseMeanCapacity(int n, double d2, double d3) {
        return this.nextPrime(Math.max(n + 1, (int)((double)(2 * n) / (d2 + d3))));
    }

    protected int chooseShrinkCapacity(int n, double d2, double d3) {
        return this.nextPrime(Math.max(n + 1, (int)((double)(4 * n) / (d2 + 3.0 * d3))));
    }

    public abstract void clear();

    public void ensureCapacity(int n) {
    }

    public boolean isEmpty() {
        return this.distinct == 0;
    }

    protected int nextPrime(int n) {
        return PrimeFinder.nextPrime(n);
    }

    protected void setUp(int n, double d2, double d3) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + n);
        }
        if (d2 < 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + d2);
        }
        if (d3 <= 0.0 || d3 >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + d3);
        }
        if (d2 >= d3) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + d2 + " and maxLoadFactor: " + d3);
        }
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
    }
}

