/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.LongProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.AbstractLongList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class LongArrayList
extends AbstractLongList {
    protected long[] elements;

    public LongArrayList() {
        this(10);
    }

    public LongArrayList(long[] lArray) {
        this.elements(lArray);
    }

    public LongArrayList(int n) {
        this(new long[n]);
        this.setSizeRaw(0);
    }

    public void add(long l) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = l;
    }

    public void beforeInsert(int n, long l) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = l;
        ++this.size;
    }

    public int binarySearchFromTo(long l, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, l, n, n2);
    }

    public Object clone() {
        LongArrayList longArrayList = new LongArrayList((long[])this.elements.clone());
        longArrayList.setSizeRaw(this.size);
        return longArrayList;
    }

    public LongArrayList copy() {
        return (LongArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, long l, long l2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        int n3 = (int)(l2 - l + 1L);
        int[] nArray = new int[n3];
        long[] lArray = this.elements;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = (int)(lArray[n4++] - l);
            nArray[n5] = nArray[n5] + 1;
        }
        int n6 = n;
        long l3 = l;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = nArray[n7];
            if (n8 > 0) {
                if (n8 == 1) {
                    lArray[n6++] = l3;
                } else {
                    int n9 = n6 + n8 - 1;
                    this.fillFromToWith(n6, n9, l3);
                    n6 = n9 + 1;
                }
            }
            ++n7;
            ++l3;
        }
    }

    public long[] elements() {
        return this.elements;
    }

    public AbstractLongList elements(long[] lArray) {
        this.elements = lArray;
        this.size = lArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        LongArrayList longArrayList = (LongArrayList)object;
        if (this.size() != longArrayList.size()) {
            return false;
        }
        long[] lArray = this.elements();
        long[] lArray2 = longArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (lArray[n] == lArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(LongProcedure longProcedure) {
        long[] lArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (longProcedure.apply(lArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public long get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public long getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(long l, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        long[] lArray = this.elements;
        int n3 = n;
        while (n3 <= n2) {
            if (l == lArray[n3]) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int lastIndexOfFromTo(long l, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        long[] lArray = this.elements;
        int n3 = n2;
        while (n3 >= n) {
            if (l == lArray[n3]) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public AbstractLongList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new LongArrayList(0);
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        long[] lArray = new long[n2 - n + 1];
        System.arraycopy(this.elements, n, lArray, 0, n2 - n + 1);
        return new LongArrayList(lArray);
    }

    public boolean removeAll(AbstractLongList abstractLongList) {
        double d2;
        if (!(abstractLongList instanceof LongArrayList)) {
            return super.removeAll(abstractLongList);
        }
        if (abstractLongList.size() == 0) {
            return false;
        }
        int n = abstractLongList.size() - 1;
        int n2 = 0;
        long[] lArray = this.elements;
        int n3 = this.size();
        double d3 = abstractLongList.size();
        if ((d3 + (d2 = (double)n3)) * Arithmetic.log2(d3) < d2 * d3) {
            LongArrayList longArrayList = (LongArrayList)abstractLongList.clone();
            longArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (longArrayList.binarySearchFromTo(lArray[n4], 0, n) < 0) {
                    lArray[n2++] = lArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractLongList.indexOfFromTo(lArray[n5], 0, n) < 0) {
                    lArray[n2++] = lArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractLongList abstractLongList, int n3) {
        if (!(abstractLongList instanceof LongArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractLongList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            AbstractList.checkRangeFromTo(n, n2, this.size());
            AbstractList.checkRangeFromTo(n3, n3 + n4 - 1, abstractLongList.size());
            System.arraycopy(((LongArrayList)abstractLongList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractLongList abstractLongList) {
        double d2;
        if (!(abstractLongList instanceof LongArrayList)) {
            return super.retainAll(abstractLongList);
        }
        int n = abstractLongList.size() - 1;
        int n2 = 0;
        long[] lArray = this.elements;
        int n3 = this.size();
        double d3 = abstractLongList.size();
        if ((d3 + (d2 = (double)n3)) * Arithmetic.log2(d3) < d2 * d3) {
            LongArrayList longArrayList = (LongArrayList)abstractLongList.clone();
            longArrayList.quickSort();
            int n4 = 0;
            while (n4 < n3) {
                if (longArrayList.binarySearchFromTo(lArray[n4], 0, n) >= 0) {
                    lArray[n2++] = lArray[n4];
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (abstractLongList.indexOfFromTo(lArray[n5], 0, n) >= 0) {
                    lArray[n2++] = lArray[n5];
                }
                ++n5;
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        long[] lArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            long l = lArray[n3];
            lArray[n3++] = lArray[n2];
            lArray[n2--] = l;
        }
    }

    public void set(int n, long l) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = l;
    }

    public void setQuick(int n, long l) {
        this.elements[n] = l;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        long[] lArray = this.elements;
        int n3 = n;
        while (n3 < n2) {
            int n4 = uniform.nextIntFromTo(n3, n2);
            long l = lArray[n4];
            lArray[n4] = lArray[n3];
            lArray[n3] = l;
            ++n3;
        }
    }

    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        AbstractList.checkRangeFromTo(n, n2, this.size);
        long l = this.elements[n];
        long l2 = this.elements[n];
        long[] lArray = this.elements;
        int n3 = n + 1;
        while (n3 <= n2) {
            long l3;
            if ((l3 = lArray[n3++]) > l2) {
                l2 = l3;
                continue;
            }
            if (l3 >= l) continue;
            l = l3;
        }
        double d2 = (double)n2 - (double)n + 1.0;
        double d3 = d2 * Math.log(d2) / 0.6931471805599453;
        double d4 = (double)l2 - (double)l + 1.0;
        double d5 = Math.max(d4, d2);
        if (d4 < 10000.0 && d5 < d3) {
            this.countSortFromTo(n, n2, l, l2);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

