/* 

Copyright (c) 2009 Thomas Junier and Evgeny Zdobnov, University of Geneva
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
* Neither the name of the University of Geneva nor the names of its
    contributors may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include <stdlib.h>

#include "list.h"
#include "hash.h"
#include "rnode.h"
#include "nodemap.h"
#include "subtree.h"

enum monophyly is_monophyletic(struct llist *descendants, struct rnode *subtree_root)
{
	int result = MONOPH_TRUE;

	struct hash *leaf_map = get_leaf_label_map_from_node(subtree_root);
	if (NULL == leaf_map) 
		return MONOPH_ERROR;
	if (leaf_map->count != descendants->count) {
		destroy_hash(leaf_map);
		return MONOPH_FALSE;
	}
	struct list_elem *el;
	for (el = descendants->head; NULL != el; el = el->next) {
		char *label = ((struct rnode *) el->data)->label;
		if (NULL == hash_get(leaf_map, label)) {
			result = MONOPH_FALSE;
			break;
		}
	}

	destroy_hash(leaf_map);

	return result;
}
