/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearch;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class ColumnFormatterLDAPSearchOutputHandler
extends LDAPSearchOutputHandler {
    private final ArrayList<String> formattedLines;
    private final ColumnFormatter formatter;
    private final int maxCommentWidth;
    private final LDAPSearch ldapSearch;
    private final Object[] columnValues;
    private final String[] attributes;
    private final StringBuilder formattedLineBuffer;

    ColumnFormatterLDAPSearchOutputHandler(LDAPSearch ldapSearch, OutputFormat outputFormat, List<String> requestedAttributes, int maxCommentWidth) {
        this.ldapSearch = ldapSearch;
        this.maxCommentWidth = maxCommentWidth;
        this.attributes = new String[requestedAttributes.size()];
        requestedAttributes.toArray(this.attributes);
        this.columnValues = new Object[this.attributes.length + 1];
        FormattableColumn[] columns = new FormattableColumn[this.attributes.length + 1];
        columns[0] = new FormattableColumn(10, HorizontalAlignment.LEFT, "DN");
        for (int i = 0; i < this.attributes.length; ++i) {
            columns[i + 1] = new FormattableColumn(10, HorizontalAlignment.LEFT, this.attributes[i]);
        }
        this.formatter = new ColumnFormatter(false, null, outputFormat, " ", columns);
        this.formattedLines = new ArrayList(20);
        this.formattedLineBuffer = new StringBuilder(100);
    }

    @Override
    public void formatHeader() {
        for (String headerLine : this.formatter.getHeaderLines(false)) {
            this.ldapSearch.writeOut("# " + headerLine);
        }
    }

    @Override
    public void formatSearchResultEntry(SearchResultEntry entry) {
        this.columnValues[0] = entry.getDN();
        int i = 1;
        for (String attribute : this.attributes) {
            String value = entry.getAttributeValue(attribute);
            this.columnValues[i] = value == null ? "" : value;
            ++i;
        }
        this.ldapSearch.writeOut(this.formatter.formatRow(this.columnValues));
    }

    @Override
    public void formatSearchResultReference(SearchResultReference ref) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultReference(this.formattedLines, ref, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatResult(LDAPResult result) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatResult(this.formattedLines, result, true, false, 0, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }

    @Override
    public void formatUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, true, 0, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.ldapSearch.writeOut(this.formattedLineBuffer.toString());
    }
}

