/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.persist.DefaultOIDAllocator;
import com.unboundid.ldap.sdk.persist.FilterUsage;
import com.unboundid.ldap.sdk.persist.LDAPGetter;
import com.unboundid.ldap.sdk.persist.LDAPObject;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.OIDAllocator;
import com.unboundid.ldap.sdk.persist.ObjectEncoder;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetterInfo
implements Serializable {
    private static final long serialVersionUID = 1578187843924054389L;
    private final boolean includeInAdd;
    private final boolean includeInModify;
    private final boolean includeInRDN;
    private final Class<?> containingClass;
    private final FilterUsage filterUsage;
    private final Method method;
    private final ObjectEncoder encoder;
    private final String attributeName;
    private final String[] objectClasses;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GetterInfo(Method m, Class<?> c) throws LDAPPersistException {
        Validator.ensureNotNull(m, c);
        this.method = m;
        m.setAccessible(true);
        LDAPGetter a = m.getAnnotation(LDAPGetter.class);
        if (a == null) {
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_METHOD_NOT_ANNOTATED.get(m.getName(), c.getName()));
        }
        LDAPObject o = c.getAnnotation(LDAPObject.class);
        if (o == null) {
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_CLASS_NOT_ANNOTATED.get(c.getName()));
        }
        this.containingClass = c;
        this.includeInRDN = a.inRDN();
        this.includeInAdd = this.includeInRDN || a.inAdd();
        this.includeInModify = !this.includeInRDN && a.inModify();
        this.filterUsage = a.filterUsage();
        int modifiers = m.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_METHOD_STATIC.get(m.getName(), c.getName()));
        }
        Type[] params = m.getGenericParameterTypes();
        if (params.length > 0) {
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_METHOD_TAKES_ARGUMENTS.get(m.getName(), c.getName()));
        }
        try {
            this.encoder = a.encoderClass().newInstance();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_CANNOT_GET_ENCODER.get(a.encoderClass().getName(), m.getName(), c.getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
        }
        if (!this.encoder.supportsType(m.getGenericReturnType())) {
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_ENCODER_UNSUPPORTED_TYPE.get(this.encoder.getClass().getName(), m.getName(), c.getName(), String.valueOf(m.getGenericReturnType())));
        }
        String structuralClass = o.structuralClass().isEmpty() ? StaticUtils.getUnqualifiedClassName(c) : o.structuralClass();
        String[] ocs = a.objectClass();
        this.objectClasses = ocs == null || ocs.length == 0 ? new String[]{structuralClass} : ocs;
        for (String s : this.objectClasses) {
            if (s.equalsIgnoreCase(structuralClass)) continue;
            boolean found = false;
            for (String oc : o.auxiliaryClass()) {
                if (!s.equalsIgnoreCase(oc)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_INVALID_OC.get(m.getName(), c.getName(), s));
        }
        String attrName = a.attribute();
        if (attrName == null || attrName.isEmpty()) {
            String methodName = m.getName();
            if (!methodName.startsWith("get") || methodName.length() < 4) throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_CANNOT_INFER_ATTR.get(methodName, c.getName()));
            this.attributeName = StaticUtils.toInitialLowerCase(methodName.substring(3));
            return;
        } else {
            this.attributeName = attrName;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getContainingClass() {
        return this.containingClass;
    }

    public boolean includeInAdd() {
        return this.includeInAdd;
    }

    public boolean includeInModify() {
        return this.includeInModify;
    }

    public boolean includeInRDN() {
        return this.includeInRDN;
    }

    public FilterUsage getFilterUsage() {
        return this.filterUsage;
    }

    public ObjectEncoder getEncoder() {
        return this.encoder;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String[] getObjectClasses() {
        return this.objectClasses;
    }

    AttributeTypeDefinition constructAttributeType() throws LDAPPersistException {
        return this.constructAttributeType(DefaultOIDAllocator.getInstance());
    }

    AttributeTypeDefinition constructAttributeType(OIDAllocator a) throws LDAPPersistException {
        return this.encoder.constructAttributeType(this.method, a);
    }

    Attribute encode(Object o) throws LDAPPersistException {
        try {
            Object methodValue = this.method.invoke(o, new Object[0]);
            if (methodValue == null) {
                return null;
            }
            return this.encoder.encodeMethodValue(this.method, methodValue, this.attributeName);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(PersistMessages.ERR_GETTER_INFO_CANNOT_ENCODE.get(this.method.getName(), this.containingClass.getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
        }
    }
}

