/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordModifyExtendedResult
extends ExtendedResult {
    private static final long serialVersionUID = -160274020063799410L;
    private final ASN1OctetString generatedPassword;

    public PasswordModifyExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1Element[] elements;
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.generatedPassword = null;
            return;
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_MODIFY_RESPONSE_VALUE_NOT_SEQUENCE.get(e), e);
        }
        if (elements.length == 0) {
            this.generatedPassword = null;
            return;
        }
        if (elements.length != 1) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PW_MODIFY_RESPONSE_MULTIPLE_ELEMENTS.get());
        }
        this.generatedPassword = ASN1OctetString.decodeAsOctetString(elements[0]);
    }

    public PasswordModifyExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, ASN1OctetString generatedPassword, Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, PasswordModifyExtendedResult.encodeValue(generatedPassword), responseControls);
        this.generatedPassword = generatedPassword;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString generatedPassword) {
        if (generatedPassword == null) {
            return null;
        }
        ASN1Element[] elements = new ASN1Element[]{new ASN1OctetString(-128, generatedPassword.getValue())};
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public String getGeneratedPassword() {
        if (this.generatedPassword == null) {
            return null;
        }
        return this.generatedPassword.stringValue();
    }

    public byte[] getGeneratedPasswordBytes() {
        if (this.generatedPassword == null) {
            return null;
        }
        return this.generatedPassword.getValue();
    }

    public ASN1OctetString getRawGeneratedPassword() {
        return this.generatedPassword;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_PASSWORD_MODIFY.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("PasswordModifyExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.generatedPassword != null) {
            buffer.append(", generatedPassword='");
            buffer.append(this.generatedPassword.stringValue());
            buffer.append('\'');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

