/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class TransportStats
implements Writeable,
ToXContentFragment {
    private final long serverOpen;
    private final long totalOutboundConnections;
    private final long rxCount;
    private final long rxSize;
    private final long txCount;
    private final long txSize;

    public TransportStats(long serverOpen, long totalOutboundConnections, long rxCount, long rxSize, long txCount, long txSize) {
        this.serverOpen = serverOpen;
        this.totalOutboundConnections = totalOutboundConnections;
        this.rxCount = rxCount;
        this.rxSize = rxSize;
        this.txCount = txCount;
        this.txSize = txSize;
    }

    public TransportStats(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.totalOutboundConnections = in.getVersion().onOrAfter(Version.V_7_10_0) ? in.readVLong() : 0L;
        this.rxCount = in.readVLong();
        this.rxSize = in.readVLong();
        this.txCount = in.readVLong();
        this.txSize = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeVLong(this.totalOutboundConnections);
        }
        out.writeVLong(this.rxCount);
        out.writeVLong(this.rxSize);
        out.writeVLong(this.txCount);
        out.writeVLong(this.txSize);
    }

    public long serverOpen() {
        return this.serverOpen;
    }

    public long getServerOpen() {
        return this.serverOpen();
    }

    public long rxCount() {
        return this.rxCount;
    }

    public long getRxCount() {
        return this.rxCount();
    }

    public ByteSizeValue rxSize() {
        return new ByteSizeValue(this.rxSize);
    }

    public ByteSizeValue getRxSize() {
        return this.rxSize();
    }

    public long txCount() {
        return this.txCount;
    }

    public long getTxCount() {
        return this.txCount();
    }

    public ByteSizeValue txSize() {
        return new ByteSizeValue(this.txSize);
    }

    public ByteSizeValue getTxSize() {
        return this.txSize();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("transport");
        builder.field("server_open", this.serverOpen);
        builder.field("total_outbound_connections", this.totalOutboundConnections);
        builder.field("rx_count", this.rxCount);
        builder.humanReadableField("rx_size_in_bytes", "rx_size", (Object)new ByteSizeValue(this.rxSize));
        builder.field("tx_count", this.txCount);
        builder.humanReadableField("tx_size_in_bytes", "tx_size", (Object)new ByteSizeValue(this.txSize));
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String TRANSPORT = "transport";
        static final String SERVER_OPEN = "server_open";
        static final String TOTAL_OUTBOUND_CONNECTIONS = "total_outbound_connections";
        static final String RX_COUNT = "rx_count";
        static final String RX_SIZE = "rx_size";
        static final String RX_SIZE_IN_BYTES = "rx_size_in_bytes";
        static final String TX_COUNT = "tx_count";
        static final String TX_SIZE = "tx_size";
        static final String TX_SIZE_IN_BYTES = "tx_size_in_bytes";

        Fields() {
        }
    }
}

