/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractScriptFieldQuery;

public final class GeoPointScriptFieldDistanceFeatureQuery
extends AbstractScriptFieldQuery<AbstractLongFieldScript> {
    private final double originLat;
    private final double originLon;
    private final double pivotDistance;

    public GeoPointScriptFieldDistanceFeatureQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, double originLat, double originLon, double pivotDistance) {
        super(script, fieldName, leafFactory);
        GeoUtils.checkLatitude((double)originLat);
        GeoUtils.checkLongitude((double)originLon);
        this.originLon = originLon;
        this.originLat = originLat;
        if (pivotDistance <= 0.0) {
            throw new IllegalArgumentException("pivotDistance must be > 0, got " + pivotDistance);
        }
        this.pivotDistance = pivotDistance;
    }

    double lat() {
        return this.originLat;
    }

    double lon() {
        return this.originLon;
    }

    double pivot() {
        return this.pivotDistance;
    }

    @Override
    protected boolean matches(AbstractLongFieldScript scriptContext, int docId) {
        scriptContext.runForDoc(docId);
        return scriptContext.count() > 0;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) {
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public void extractTerms(Set<Term> terms) {
            }

            public Scorer scorer(LeafReaderContext context) {
                return new DistanceScorer(this, (AbstractLongFieldScript)GeoPointScriptFieldDistanceFeatureQuery.this.scriptContextFunction().apply(context), context.reader().maxDoc(), boost);
            }

            public Explanation explain(LeafReaderContext context, int doc) {
                AbstractLongFieldScript script = (AbstractLongFieldScript)GeoPointScriptFieldDistanceFeatureQuery.this.scriptContextFunction().apply(context);
                script.runForDoc(doc);
                long encoded = GeoPointScriptFieldDistanceFeatureQuery.this.valueWithMinAbsoluteDistance(script);
                int latitudeBits = (int)(encoded >> 32);
                int longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL);
                double lat = GeoEncodingUtils.decodeLatitude((int)latitudeBits);
                double lon = GeoEncodingUtils.decodeLongitude((int)longitudeBits);
                double distance = SloppyMath.haversinMeters((double)GeoPointScriptFieldDistanceFeatureQuery.this.originLat, (double)GeoPointScriptFieldDistanceFeatureQuery.this.originLon, (double)lat, (double)lon);
                float score = (float)((double)boost * (GeoPointScriptFieldDistanceFeatureQuery.this.pivotDistance / (GeoPointScriptFieldDistanceFeatureQuery.this.pivotDistance + distance)));
                return Explanation.match((Number)Float.valueOf(score), (String)"Distance score, computed as weight * pivotDistance / (pivotDistance + abs(distance)) from:", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(boost), (String)"weight", (Explanation[])new Explanation[0]), Explanation.match((Number)GeoPointScriptFieldDistanceFeatureQuery.this.pivotDistance, (String)"pivotDistance", (Explanation[])new Explanation[0]), Explanation.match((Number)GeoPointScriptFieldDistanceFeatureQuery.this.originLat, (String)"originLat", (Explanation[])new Explanation[0]), Explanation.match((Number)GeoPointScriptFieldDistanceFeatureQuery.this.originLon, (String)"originLon", (Explanation[])new Explanation[0]), Explanation.match((Number)lat, (String)"current lat", (Explanation[])new Explanation[0]), Explanation.match((Number)lon, (String)"current lon", (Explanation[])new Explanation[0]), Explanation.match((Number)distance, (String)"distance", (Explanation[])new Explanation[0])});
            }
        };
    }

    private double getDistance(AbstractLongFieldScript script) {
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < script.count(); ++i) {
            minDistance = Math.min(minDistance, this.getDistanceFromEncoded(script.values()[i]));
        }
        return minDistance;
    }

    private double getDistanceFromEncoded(long encoded) {
        int latitudeBits = (int)(encoded >> 32);
        int longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL);
        double lat = GeoEncodingUtils.decodeLatitude((int)latitudeBits);
        double lon = GeoEncodingUtils.decodeLongitude((int)longitudeBits);
        return SloppyMath.haversinMeters((double)this.originLat, (double)this.originLon, (double)lat, (double)lon);
    }

    long valueWithMinAbsoluteDistance(AbstractLongFieldScript script) {
        double minDistance = Double.POSITIVE_INFINITY;
        long minDistanceValue = Long.MAX_VALUE;
        for (int i = 0; i < script.count(); ++i) {
            double distance = this.getDistanceFromEncoded(script.values()[i]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minDistanceValue = script.values()[i];
        }
        return minDistanceValue;
    }

    float score(float weight, double distance) {
        return (float)((double)weight * (this.pivotDistance / (this.pivotDistance + distance)));
    }

    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().equals(field)) {
            b.append(this.fieldName()).append(":");
        }
        b.append(((Object)((Object)this)).getClass().getSimpleName());
        b.append("(lat=").append(this.originLat);
        b.append(",lon=").append(this.originLon);
        b.append(",pivot=").append(this.pivotDistance).append(")");
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originLat, this.originLon, this.pivotDistance);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GeoPointScriptFieldDistanceFeatureQuery other = (GeoPointScriptFieldDistanceFeatureQuery)((Object)obj);
        return this.originLon == other.originLon && this.originLat == other.originLat && this.pivotDistance == other.pivotDistance;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName())) {
            visitor.visitLeaf((Query)this);
        }
    }

    private class DistanceScorer
    extends Scorer {
        private final AbstractLongFieldScript script;
        private final TwoPhaseIterator twoPhase;
        private final DocIdSetIterator disi;
        private final float weight;
        private double maxDistance;

        protected DistanceScorer(Weight weight, final AbstractLongFieldScript script, int maxDoc, float boost) {
            super(weight);
            this.maxDistance = 2.0015114352186374E7;
            this.script = script;
            this.twoPhase = new TwoPhaseIterator(DocIdSetIterator.all((int)maxDoc)){

                public boolean matches() {
                    return GeoPointScriptFieldDistanceFeatureQuery.this.matches(script, this.approximation.docID());
                }

                public float matchCost() {
                    return 9000.0f;
                }
            };
            this.disi = TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhase);
            this.weight = boost;
        }

        public int docID() {
            return this.disi.docID();
        }

        public float score() throws IOException {
            if (this.script.count() == 0) {
                return 0.0f;
            }
            return GeoPointScriptFieldDistanceFeatureQuery.this.score(this.weight, GeoPointScriptFieldDistanceFeatureQuery.this.getDistance(this.script));
        }

        public float getMaxScore(int upTo) {
            return this.weight;
        }

        public DocIdSetIterator iterator() {
            return this.disi;
        }

        public TwoPhaseIterator twoPhaseIterator() {
            return this.twoPhase;
        }
    }
}

