/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValuesSourceConfig {
    private final ValuesSourceType valuesSourceType;
    private final FieldContext fieldContext;
    private final AggregationScript.LeafFactory script;
    private final ValueType scriptValueType;
    private final boolean unmapped;
    private final DocValueFormat format;
    private final Object missing;
    private final ZoneId timeZone;
    private final ValuesSource valuesSource;

    public static ValuesSourceConfig resolve(AggregationContext context, ValueType userValueTypeHint, String field, Script script, Object missing, ZoneId timeZone, String format, ValuesSourceType defaultValueSourceType) {
        return ValuesSourceConfig.internalResolve(context, userValueTypeHint, field, script, missing, timeZone, format, defaultValueSourceType, ValuesSourceConfig::getMappingFromRegistry);
    }

    public static ValuesSourceConfig resolveUnregistered(AggregationContext context, ValueType userValueTypeHint, String field, Script script, Object missing, ZoneId timeZone, String format, ValuesSourceType defaultValueSourceType) {
        return ValuesSourceConfig.internalResolve(context, userValueTypeHint, field, script, missing, timeZone, format, defaultValueSourceType, ValuesSourceConfig::getLegacyMapping);
    }

    private static ValuesSourceConfig internalResolve(AggregationContext context, ValueType userValueTypeHint, String field, Script script, Object missing, ZoneId timeZone, String format, ValuesSourceType defaultValueSourceType, FieldResolver fieldResolver) {
        ValuesSourceType valuesSourceType = null;
        ValueType scriptValueType = userValueTypeHint;
        FieldContext fieldContext = null;
        AggregationScript.LeafFactory aggregationScript = ValuesSourceConfig.createScript(script, context);
        boolean unmapped = false;
        if (userValueTypeHint != null) {
            valuesSourceType = userValueTypeHint.getValuesSourceType();
        }
        if (field == null) {
            if (script == null) {
                throw new IllegalStateException("value source config is invalid; must have either a field or a script");
            }
        } else {
            fieldContext = context.buildFieldContext(field);
            if (fieldContext == null) {
                unmapped = true;
                aggregationScript = null;
            } else if (valuesSourceType == null) {
                valuesSourceType = fieldResolver.getValuesSourceType(fieldContext, userValueTypeHint, defaultValueSourceType);
            }
        }
        if (valuesSourceType == null) {
            valuesSourceType = defaultValueSourceType;
        }
        DocValueFormat docValueFormat = ValuesSourceConfig.resolveFormat(format, valuesSourceType, timeZone, fieldContext);
        ValuesSourceConfig config = new ValuesSourceConfig(valuesSourceType, fieldContext, unmapped, aggregationScript, scriptValueType, missing, timeZone, docValueFormat, context);
        return config;
    }

    private static ValuesSourceType getMappingFromRegistry(FieldContext fieldContext, ValueType userValueTypeHint, ValuesSourceType defaultValuesSourceType) {
        return fieldContext.indexFieldData().getValuesSourceType();
    }

    private static ValuesSourceType getLegacyMapping(FieldContext fieldContext, ValueType userValueTypeHint, ValuesSourceType defaultValuesSourceType) {
        IndexFieldData<?> indexFieldData = fieldContext.indexFieldData();
        if (indexFieldData instanceof IndexNumericFieldData) {
            return CoreValuesSourceType.NUMERIC;
        }
        if (indexFieldData instanceof IndexGeoPointFieldData) {
            return CoreValuesSourceType.GEOPOINT;
        }
        if (fieldContext.fieldType() instanceof RangeFieldMapper.RangeFieldType) {
            return CoreValuesSourceType.RANGE;
        }
        if (userValueTypeHint == null) {
            return defaultValuesSourceType;
        }
        return userValueTypeHint.getValuesSourceType();
    }

    private static AggregationScript.LeafFactory createScript(Script script, AggregationContext context) {
        if (script == null) {
            return null;
        }
        AggregationScript.Factory factory = context.compile(script, AggregationScript.CONTEXT);
        return factory.newFactory(script.getParams(), context.lookup());
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValuesSourceType valuesSourceType, @Nullable ZoneId tz, @Nullable FieldContext fieldContext) {
        if (fieldContext != null) {
            return fieldContext.fieldType().docValueFormat(format, tz);
        }
        return valuesSourceType.getFormatter(format, tz);
    }

    public static ValuesSourceConfig resolveFieldOnly(MappedFieldType fieldType, AggregationContext context) {
        FieldContext fieldContext = context.buildFieldContext(fieldType);
        ValuesSourceType vstype = fieldContext.indexFieldData().getValuesSourceType();
        return new ValuesSourceConfig(vstype, fieldContext, false, null, null, null, null, null, context);
    }

    public static ValuesSourceConfig resolveUnmapped(ValuesSourceType valuesSourceType, AggregationContext context) {
        return new ValuesSourceConfig(valuesSourceType, null, true, null, null, null, null, null, context);
    }

    private ValuesSourceConfig() {
        throw new UnsupportedOperationException();
    }

    public ValuesSourceConfig(ValuesSourceType valuesSourceType, FieldContext fieldContext, boolean unmapped, AggregationScript.LeafFactory script, ValueType scriptValueType, Object missing, ZoneId timeZone, DocValueFormat format, AggregationContext context) {
        if (unmapped && fieldContext != null) {
            throw new IllegalStateException("value source config is invalid; marked as unmapped but specified a mapped field");
        }
        this.valuesSourceType = valuesSourceType;
        this.fieldContext = fieldContext;
        this.unmapped = unmapped;
        this.script = script;
        this.scriptValueType = scriptValueType;
        this.missing = missing;
        this.timeZone = timeZone;
        DocValueFormat docValueFormat = this.format = format == null ? DocValueFormat.RAW : format;
        if (!this.valid()) {
            throw new IllegalStateException("value source config is invalid; must have either a field context or a script or marked as unwrapped");
        }
        this.valuesSource = this.constructValuesSource(missing, format, context);
    }

    private ValuesSource constructValuesSource(Object missing, DocValueFormat format, AggregationContext context) {
        ValuesSource vs = this.unmapped ? this.valueSourceType().getEmpty() : (this.fieldContext() == null ? this.valueSourceType().getScript(this.script(), this.scriptValueType()) : this.valueSourceType().getField(this.fieldContext(), this.script(), context));
        if (this.missing() != null) {
            return this.valueSourceType().replaceMissing(vs, missing, format, context);
        }
        return vs;
    }

    public ValuesSourceType valueSourceType() {
        return this.valuesSourceType;
    }

    public FieldContext fieldContext() {
        return this.fieldContext;
    }

    public DoubleUnaryOperator reduceToStoredPrecisionFunction() {
        if (this.fieldContext() != null && this.fieldType() instanceof NumberFieldMapper.NumberFieldType) {
            return ((NumberFieldMapper.NumberFieldType)this.fieldType())::reduceToStoredPrecision;
        }
        return value -> value;
    }

    @Nullable
    public MappedFieldType fieldType() {
        return this.fieldContext == null ? null : this.fieldContext.fieldType();
    }

    public AggregationScript.LeafFactory script() {
        return this.script;
    }

    public boolean hasValues() {
        return this.fieldContext != null || this.script != null || this.missing != null;
    }

    public boolean valid() {
        return this.fieldContext != null || this.script != null || this.unmapped;
    }

    public ValueType scriptValueType() {
        return this.scriptValueType;
    }

    public Object missing() {
        return this.missing;
    }

    public ZoneId timezone() {
        return this.timeZone;
    }

    public DocValueFormat format() {
        return this.format;
    }

    public ValuesSource getValuesSource() {
        return this.valuesSource;
    }

    public Function<Rounding, Rounding.Prepared> roundingPreparer() throws IOException {
        return this.valuesSource.roundingPreparer();
    }

    public boolean hasOrdinals() {
        return this.valuesSource.hasOrdinals();
    }

    @Nullable
    public Function<byte[], Number> getPointReaderOrNull() {
        return this.alignesWithSearchIndex() ? this.fieldType().pointReaderIfPossible() : null;
    }

    public boolean alignesWithSearchIndex() {
        return this.script() == null && this.missing() == null && this.fieldType() != null && this.fieldType().isSearchable();
    }

    public String getDescription() {
        if (this.script != null) {
            return "Script yielding [" + (this.scriptValueType != null ? this.scriptValueType.getPreferredName() : "unknown type") + "]";
        }
        MappedFieldType fieldType = this.fieldType();
        if (fieldType != null) {
            return "Field [" + fieldType.name() + "] of type [" + fieldType.typeName() + "]";
        }
        return "unmapped field";
    }

    @FunctionalInterface
    private static interface FieldResolver {
        public ValuesSourceType getValuesSourceType(FieldContext var1, ValueType var2, ValuesSourceType var3);
    }
}

