/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class NestedUtils {
    private NestedUtils() {
    }

    public static <T> Map<String, List<T>> partitionByChildren(String scope, List<String> children, List<T> inputs, Function<T, String> pathFunction) {
        if (children.isEmpty()) {
            return Collections.singletonMap(scope, inputs);
        }
        HashMap<String, List<T>> output = new HashMap<String, List<T>>();
        output.put(scope, new ArrayList());
        for (String child : children) {
            output.put(child, new ArrayList());
        }
        if (inputs.isEmpty()) {
            return output;
        }
        Iterator<String> childrenIterator = children.iterator();
        String currentChild = childrenIterator.next();
        Iterator<T> inputIterator = inputs.iterator();
        T currentInput = inputIterator.next();
        String currentInputName = pathFunction.apply(currentInput);
        assert (currentInputName.startsWith(scope));
        while (currentChild != null) {
            if (currentInputName.compareTo(currentChild) < 0) {
                ((List)output.get(scope)).add(currentInput);
                if (!inputIterator.hasNext()) {
                    return output;
                }
                currentInput = inputIterator.next();
                currentInputName = pathFunction.apply(currentInput);
                assert (currentInputName.startsWith(scope));
                continue;
            }
            if (currentInputName.startsWith(currentChild + ".")) {
                ((List)output.get(currentChild)).add(currentInput);
                if (!inputIterator.hasNext()) {
                    return output;
                }
                currentInput = inputIterator.next();
                currentInputName = pathFunction.apply(currentInput);
                assert (currentInputName.startsWith(scope));
                continue;
            }
            if (!childrenIterator.hasNext()) break;
            currentChild = childrenIterator.next();
            if (currentChild != null && currentInputName.compareTo(currentChild) >= 0) continue;
            ((List)output.get(scope)).add(currentInput);
            if (!inputIterator.hasNext()) {
                return output;
            }
            currentInput = inputIterator.next();
            currentInputName = pathFunction.apply(currentInput);
            assert (currentInputName.startsWith(scope));
        }
        ((List)output.get(scope)).add(currentInput);
        while (inputIterator.hasNext()) {
            currentInput = inputIterator.next();
            currentInputName = pathFunction.apply(currentInput);
            assert (currentInputName.startsWith(scope));
            ((List)output.get(scope)).add(currentInput);
        }
        return output;
    }
}

