/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotsService;

public final class FinalizeSnapshotContext
extends ActionListener.Delegating<Tuple<RepositoryData, SnapshotInfo>, Tuple<RepositoryData, SnapshotInfo>> {
    private final ShardGenerations updatedShardGenerations;
    private final SetOnce<Map<RepositoryShardId, Set<ShardGeneration>>> obsoleteGenerations = new SetOnce();
    private final long repositoryStateId;
    private final Metadata clusterMetadata;
    private final SnapshotInfo snapshotInfo;
    private final Version repositoryMetaVersion;

    public FinalizeSnapshotContext(ShardGenerations updatedShardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, ActionListener<Tuple<RepositoryData, SnapshotInfo>> listener) {
        super(listener);
        this.updatedShardGenerations = updatedShardGenerations;
        this.repositoryStateId = repositoryStateId;
        this.clusterMetadata = clusterMetadata;
        this.snapshotInfo = snapshotInfo;
        this.repositoryMetaVersion = repositoryMetaVersion;
    }

    public long repositoryStateId() {
        return this.repositoryStateId;
    }

    public ShardGenerations updatedShardGenerations() {
        return this.updatedShardGenerations;
    }

    public SnapshotInfo snapshotInfo() {
        return this.snapshotInfo;
    }

    public Version repositoryMetaVersion() {
        return this.repositoryMetaVersion;
    }

    public Metadata clusterMetadata() {
        return this.clusterMetadata;
    }

    public Map<RepositoryShardId, Set<ShardGeneration>> obsoleteShardGenerations() {
        assert (this.obsoleteGenerations.get() != null) : "must only be called after #updatedClusterState";
        return (Map)this.obsoleteGenerations.get();
    }

    public ClusterState updatedClusterState(ClusterState state) {
        ClusterState updatedState = SnapshotsService.stateWithoutSnapshot(state, this.snapshotInfo.snapshot(), this.updatedShardGenerations);
        this.obsoleteGenerations.set(updatedState.custom("snapshots", SnapshotsInProgress.EMPTY).obsoleteGenerations(this.snapshotInfo.repository(), state.custom("snapshots", SnapshotsInProgress.EMPTY)));
        return updatedState;
    }

    @Override
    public void onResponse(Tuple<RepositoryData, SnapshotInfo> repositoryData) {
        this.delegate.onResponse(repositoryData);
    }
}

