/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ProcessInfo
implements ReportingService.Info {
    private final long refreshInterval;
    private final long id;
    private final boolean mlockall;

    public ProcessInfo(long id, boolean mlockall, long refreshInterval) {
        this.id = id;
        this.mlockall = mlockall;
        this.refreshInterval = refreshInterval;
    }

    public ProcessInfo(StreamInput in) throws IOException {
        this.refreshInterval = in.readLong();
        this.id = in.readLong();
        this.mlockall = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.refreshInterval);
        out.writeLong(this.id);
        out.writeBoolean(this.mlockall);
    }

    public long refreshInterval() {
        return this.refreshInterval;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public long getId() {
        return this.id;
    }

    public boolean isMlockall() {
        return this.mlockall;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("process");
        builder.humanReadableField("refresh_interval_in_millis", "refresh_interval", (Object)new TimeValue(this.refreshInterval));
        builder.field("id", this.id);
        builder.field("mlockall", this.mlockall);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String PROCESS = "process";
        static final String REFRESH_INTERVAL = "refresh_interval";
        static final String REFRESH_INTERVAL_IN_MILLIS = "refresh_interval_in_millis";
        static final String ID = "id";
        static final String MLOCKALL = "mlockall";

        Fields() {
        }
    }
}

