/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.ExecutorNames;

public class SystemDataStreamDescriptor {
    private final String dataStreamName;
    private final String description;
    private final Type type;
    private final ComposableIndexTemplate composableIndexTemplate;
    private final Map<String, ComponentTemplate> componentTemplates;
    private final List<String> allowedElasticProductOrigins;
    private final ExecutorNames executorNames;
    private final CharacterRunAutomaton characterRunAutomaton;

    public SystemDataStreamDescriptor(String dataStreamName, String description, Type type, ComposableIndexTemplate composableIndexTemplate, Map<String, ComponentTemplate> componentTemplates, List<String> allowedElasticProductOrigins, ExecutorNames executorNames) {
        this.dataStreamName = Objects.requireNonNull(dataStreamName, "dataStreamName must be specified");
        if (dataStreamName.length() < 2) {
            throw new IllegalArgumentException("system data stream name [" + dataStreamName + "] but must at least 2 characters in length");
        }
        if (dataStreamName.charAt(0) != '.') {
            throw new IllegalArgumentException("system data stream name [" + dataStreamName + "] but must start with the character [.]");
        }
        this.description = Objects.requireNonNull(description, "description must be specified");
        this.type = Objects.requireNonNull(type, "type must be specified");
        this.composableIndexTemplate = Objects.requireNonNull(composableIndexTemplate, "composableIndexTemplate must be provided");
        this.componentTemplates = componentTemplates == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, ComponentTemplate>(componentTemplates));
        this.allowedElasticProductOrigins = Objects.requireNonNull(allowedElasticProductOrigins, "allowedElasticProductOrigins must not be null");
        if (type == Type.EXTERNAL && allowedElasticProductOrigins.isEmpty()) {
            throw new IllegalArgumentException("External system data stream without allowed products is not a valid combination");
        }
        this.executorNames = Objects.nonNull(executorNames) ? executorNames : ExecutorNames.DEFAULT_SYSTEM_DATA_STREAM_THREAD_POOLS;
        this.characterRunAutomaton = new CharacterRunAutomaton(AssociatedIndexDescriptor.buildAutomaton(SystemDataStreamDescriptor.backingIndexPatternForDataStream(this.dataStreamName)));
    }

    public String getDataStreamName() {
        return this.dataStreamName;
    }

    public List<String> getBackingIndexNames(Metadata metadata) {
        return metadata.indices().keySet().stream().filter(arg_0 -> ((CharacterRunAutomaton)this.characterRunAutomaton).run(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public String getDescription() {
        return this.description;
    }

    public ComposableIndexTemplate getComposableIndexTemplate() {
        return this.composableIndexTemplate;
    }

    public boolean isExternal() {
        return this.type == Type.EXTERNAL;
    }

    public String getBackingIndexPattern() {
        return SystemDataStreamDescriptor.backingIndexPatternForDataStream(this.getDataStreamName());
    }

    private static String backingIndexPatternForDataStream(String dataStream) {
        return ".ds-" + dataStream + "-*";
    }

    public List<String> getAllowedElasticProductOrigins() {
        return this.allowedElasticProductOrigins;
    }

    public Map<String, ComponentTemplate> getComponentTemplates() {
        return this.componentTemplates;
    }

    public ExecutorNames getThreadPoolNames() {
        return this.executorNames;
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL;

    }
}

