/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.NodeResponseTracker;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest<NodesRequest>, NodesResponse extends BaseNodesResponse<?>, NodeRequest extends BaseNodeRequest, NodeResponse extends BaseNodeResponse>
extends HandledTransportAction<NodesRequest, NodesResponse> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final Class<NodeResponse> nodeResponseClass;
    protected final String transportNodeAction;
    private final String finalExecutor;

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodesRequest> request, Writeable.Reader<NodeRequest> nodeRequest, String nodeExecutor, String finalExecutor, Class<NodeResponse> nodeResponseClass) {
        super(actionName, transportService, actionFilters, request);
        this.threadPool = threadPool;
        this.clusterService = Objects.requireNonNull(clusterService);
        this.transportService = Objects.requireNonNull(transportService);
        this.nodeResponseClass = Objects.requireNonNull(nodeResponseClass);
        this.transportNodeAction = actionName + "[n]";
        this.finalExecutor = finalExecutor;
        transportService.registerRequestHandler(this.transportNodeAction, nodeExecutor, nodeRequest, new NodeTransportHandler());
    }

    protected TransportNodesAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodesRequest> request, Writeable.Reader<NodeRequest> nodeRequest, String nodeExecutor, Class<NodeResponse> nodeResponseClass) {
        this(actionName, threadPool, clusterService, transportService, actionFilters, request, nodeRequest, nodeExecutor, "same", nodeResponseClass);
    }

    @Override
    protected void doExecute(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
        new AsyncAction(this, task, request, listener).start();
    }

    void newResponse(Task task, NodesRequest request, NodeResponseTracker nodeResponseTracker, ActionListener<NodesResponse> listener) throws NodeResponseTracker.DiscardedResponsesException {
        if (nodeResponseTracker == null) {
            listener.onFailure(new NullPointerException("nodesResponses"));
            return;
        }
        ArrayList<BaseNodeResponse> responses = new ArrayList<BaseNodeResponse>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < nodeResponseTracker.getExpectedResponseCount(); ++i) {
            Object response = nodeResponseTracker.getResponse(i);
            if (nodeResponseTracker.getResponse(i) instanceof FailedNodeException) {
                FailedNodeException failedNodeException = (FailedNodeException)nodeResponseTracker.getResponse(i);
                failures.add(failedNodeException);
                continue;
            }
            responses.add((BaseNodeResponse)this.nodeResponseClass.cast(response));
        }
        this.newResponseAsync(task, request, responses, failures, listener);
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, List<NodeResponse> var2, List<FailedNodeException> var3);

    protected void newResponseAsync(Task task, NodesRequest request, List<NodeResponse> responses, List<FailedNodeException> failures, ActionListener<NodesResponse> listener) {
        ActionListener.completeWith(listener, () -> this.newResponse(request, responses, failures));
    }

    protected abstract NodeRequest newNodeRequest(NodesRequest var1);

    protected abstract NodeResponse newNodeResponse(StreamInput var1, DiscoveryNode var2) throws IOException;

    protected abstract NodeResponse nodeOperation(NodeRequest var1);

    protected NodeResponse nodeOperation(NodeRequest request, Task task) {
        return this.nodeOperation(request);
    }

    protected void resolveRequest(NodesRequest request, ClusterState clusterState) {
        assert (((BaseNodesRequest)request).concreteNodes() == null) : "request concreteNodes shouldn't be set";
        String[] nodesIds = clusterState.nodes().resolveNodes(((BaseNodesRequest)request).nodesIds());
        ((BaseNodesRequest)request).setConcreteNodes((DiscoveryNode[])Arrays.stream(nodesIds).map(clusterState.nodes()::get).toArray(DiscoveryNode[]::new));
    }

    protected String getTransportNodeAction(DiscoveryNode node) {
        return this.transportNodeAction;
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            if (task instanceof CancellableTask) {
                ((CancellableTask)task).ensureNotCancelled();
            }
            channel.sendResponse((TransportResponse)TransportNodesAction.this.nodeOperation(request, task));
        }
    }

    static class AsyncAction
    implements CancellableTask.CancellationListener {
        private final NodesRequest request;
        private final ActionListener<NodesResponse> listener;
        private final NodeResponseTracker nodeResponseTracker;
        private final Task task;
        final /* synthetic */ TransportNodesAction this$0;

        AsyncAction(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
            this.this$0 = this$0;
            this.task = task;
            this.request = request;
            this.listener = listener;
            if (((BaseNodesRequest)request).concreteNodes() == null) {
                this$0.resolveRequest(request, this$0.clusterService.state());
                assert (((BaseNodesRequest)request).concreteNodes() != null);
            }
            this.nodeResponseTracker = new NodeResponseTracker(((BaseNodesRequest)request).concreteNodes().length);
        }

        void start() {
            DiscoveryNode[] nodes;
            if (this.task instanceof CancellableTask) {
                CancellableTask cancellableTask = (CancellableTask)this.task;
                cancellableTask.addListener(this);
            }
            if ((nodes = ((BaseNodesRequest)this.request).concreteNodes()).length == 0) {
                this.finishHim();
                return;
            }
            TransportRequestOptions transportRequestOptions = TransportRequestOptions.timeout(((BaseNodesRequest)this.request).timeout());
            for (int i = 0; i < nodes.length; ++i) {
                final int idx = i;
                final DiscoveryNode node = nodes[i];
                String nodeId = node.getId();
                try {
                    Object nodeRequest = this.this$0.newNodeRequest(this.request);
                    if (this.task != null) {
                        nodeRequest.setParentTask(this.this$0.clusterService.localNode().getId(), this.task.getId());
                    }
                    this.this$0.transportService.sendRequest(node, this.this$0.getTransportNodeAction(node), (TransportRequest)nodeRequest, transportRequestOptions, new TransportResponseHandler<NodeResponse>(){

                        @Override
                        public NodeResponse read(StreamInput in) throws IOException {
                            return AsyncAction.this.this$0.newNodeResponse(in, node);
                        }

                        @Override
                        public void handleResponse(NodeResponse response) {
                            AsyncAction.this.onOperation(idx, response);
                        }

                        @Override
                        public void handleException(TransportException exp) {
                            AsyncAction.this.onFailure(idx, node.getId(), exp);
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    this.onFailure(idx, nodeId, e);
                }
            }
        }

        NodeResponseTracker getNodeResponseTracker() {
            return this.nodeResponseTracker;
        }

        private void onOperation(int idx, NodeResponse nodeResponse) {
            if (this.nodeResponseTracker.trackResponseAndCheckIfLast(idx, nodeResponse)) {
                this.finishHim();
            }
        }

        private void onFailure(int idx, String nodeId, Throwable t) {
            this.this$0.logger.debug((Message)new ParameterizedMessage("failed to execute on node [{}]", (Object)nodeId), t);
            if (this.nodeResponseTracker.trackResponseAndCheckIfLast(idx, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t))) {
                this.finishHim();
            }
        }

        private void finishHim() {
            CancellableTask cancellableTask;
            if (this.task instanceof CancellableTask && (cancellableTask = (CancellableTask)this.task).notifyIfCancelled(this.listener)) {
                return;
            }
            String executor = this.this$0.finalExecutor.equals("same") ? "generic" : this.this$0.finalExecutor;
            this.this$0.threadPool.executor(executor).execute(() -> {
                try {
                    this.this$0.newResponse(this.task, this.request, this.nodeResponseTracker, this.listener);
                }
                catch (NodeResponseTracker.DiscardedResponsesException e) {
                    this.listener.onFailure((Exception)e.getCause());
                }
            });
        }

        @Override
        public void onCancelled() {
            assert (this.task instanceof CancellableTask) : "task must be cancellable";
            try {
                ((CancellableTask)this.task).ensureNotCancelled();
            }
            catch (TaskCancelledException e) {
                this.nodeResponseTracker.discardIntermediateResponses(e);
            }
        }
    }
}

