/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class RecoveryRequest
extends BroadcastRequest<RecoveryRequest> {
    private boolean detailed = false;
    private boolean activeOnly = false;

    public RecoveryRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public RecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.detailed = in.readBoolean();
        this.activeOnly = in.readBoolean();
    }

    public RecoveryRequest(String ... indices) {
        super(indices, IndicesOptions.STRICT_EXPAND_OPEN_CLOSED);
    }

    public boolean detailed() {
        return this.detailed;
    }

    public void detailed(boolean detailed) {
        this.detailed = detailed;
    }

    public boolean activeOnly() {
        return this.activeOnly;
    }

    public void activeOnly(boolean activeOnly) {
        this.activeOnly = activeOnly;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.detailed);
        out.writeBoolean(this.activeOnly);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }
}

