/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GetMappingsResponse
extends ActionResponse
implements ToXContentFragment {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappings = ImmutableOpenMap.of();

    public GetMappingsResponse(ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappings) {
        this.mappings = mappings;
    }

    GetMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableOpenMap.Builder<String, MappingMetadata> typeMapBuilder = ImmutableOpenMap.builder();
            for (int j = 0; j < valueSize; ++j) {
                typeMapBuilder.put(in.readString(), new MappingMetadata(in));
            }
            indexMapBuilder.put(key, typeMapBuilder.build());
        }
        this.mappings = indexMapBuilder.build();
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> getMappings() {
        return this.mappings();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetadata>> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenMap)objectObjectCursor.value).size());
            for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                out.writeString((String)typeEntry.key);
                ((MappingMetadata)typeEntry.value).writeTo(out);
            }
        }
    }

    public static GetMappingsResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        Map parts = parser.map();
        ImmutableOpenMap.Builder builder = new ImmutableOpenMap.Builder();
        for (Map.Entry entry : parts.entrySet()) {
            String indexName = (String)entry.getKey();
            assert (entry.getValue() instanceof Map) : "expected a map as type mapping, but got: " + entry.getValue().getClass();
            Map mapping = (Map)((Map)entry.getValue()).get(MAPPINGS.getPreferredName());
            ImmutableOpenMap.Builder<String, MappingMetadata> typeBuilder = new ImmutableOpenMap.Builder<String, MappingMetadata>();
            for (Map.Entry typeEntry : mapping.entrySet()) {
                String typeName = (String)typeEntry.getKey();
                assert (typeEntry.getValue() instanceof Map) : "expected a map as inner type mapping, but got: " + typeEntry.getValue().getClass();
                Map fieldMappings = (Map)typeEntry.getValue();
                MappingMetadata mmd = new MappingMetadata(typeName, fieldMappings);
                typeBuilder.put(typeName, mmd);
            }
            builder.put(indexName, typeBuilder.build());
        }
        return new GetMappingsResponse(builder.build());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeTypeName = params.paramAsBoolean("include_type_name", false);
        for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetadata>> objectObjectCursor : this.getMappings()) {
            builder.startObject((String)objectObjectCursor.key);
            if (!includeTypeName) {
                MappingMetadata mappings = null;
                for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                    if (((String)typeEntry.key).equals("_default_")) continue;
                    assert (mappings == null);
                    mappings = (MappingMetadata)typeEntry.value;
                }
                if (mappings == null) {
                    builder.startObject(MAPPINGS.getPreferredName()).endObject();
                } else {
                    builder.field(MAPPINGS.getPreferredName(), mappings.sourceAsMap());
                }
            } else {
                builder.startObject(MAPPINGS.getPreferredName());
                for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                    builder.field((String)typeEntry.key, ((MappingMetadata)typeEntry.value).sourceAsMap());
                }
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsResponse other = (GetMappingsResponse)obj;
        return this.mappings.equals(other.mappings);
    }
}

