/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformUpdater;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportUpdateTransformAction
extends TransportTasksAction<TransformTask, UpdateTransformAction.Request, UpdateTransformAction.Response, UpdateTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateTransformAction.class);
    private final XPackLicenseState licenseState;
    private final Settings settings;
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final TransformAuditor auditor;
    private final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportUpdateTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformServices transformServices, Client client, IngestService ingestService) {
        this("cluster:admin/transform/update", settings, transportService, threadPool, actionFilters, indexNameExpressionResolver, clusterService, licenseState, transformServices, client, ingestService);
    }

    protected TransportUpdateTransformAction(String name, Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, TransformServices transformServices, Client client, IngestService ingestService) {
        super(name, clusterService, transportService, actionFilters, UpdateTransformAction.Request::fromStreamWithBWC, UpdateTransformAction.Response::fromStreamWithBWC, UpdateTransformAction.Response::fromStreamWithBWC, "same");
        this.settings = settings;
        this.licenseState = licenseState;
        this.client = client;
        this.transformConfigManager = transformServices.getConfigManager();
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = transformServices.getAuditor();
        this.threadPool = threadPool;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, UpdateTransformAction.Request request, ActionListener<UpdateTransformAction.Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        DiscoveryNodes nodes = clusterState.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException());
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, UpdateTransformAction.Response::fromStreamWithBWC));
            }
            return;
        }
        Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
        TransformConfigUpdate update = request.getUpdate();
        update.setHeaders(filteredHeaders);
        this.transformConfigManager.getTransformConfigurationForUpdate(request.getId(), (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(configAndVersion -> TransformUpdater.updateTransform(this.licenseState, this.securityContext, this.indexNameExpressionResolver, clusterState, this.settings, this.client, this.transformConfigManager, (TransformConfig)configAndVersion.v1(), update, (SeqNoPrimaryTermAndIndex)configAndVersion.v2(), request.isDeferValidation(), false, true, request.getTimeout(), (ActionListener<TransformUpdater.UpdateResult>)ActionListener.wrap(updateResponse -> {
            PersistentTasksCustomMetadata tasksMetadata;
            PersistentTasksCustomMetadata.PersistentTask transformTask;
            TransformConfig updatedConfig = updateResponse.getConfig();
            this.auditor.info(updatedConfig.getId(), "Updated transform.");
            logger.debug("[{}] Updated transform [{}]", (Object)updatedConfig.getId(), (Object)updateResponse.getStatus());
            this.checkTransformConfigAndLogWarnings(updatedConfig);
            if (update.changesSettings((TransformConfig)configAndVersion.v1()) && (transformTask = (tasksMetadata = PersistentTasksCustomMetadata.getPersistentTasksCustomMetadata((ClusterState)clusterState)).getTask(request.getId())) != null && transformTask.isAssigned() && transformTask.getState() instanceof TransformState && ((TransformState)transformTask.getState()).getTaskState() != TransformTaskState.FAILED && clusterState.nodes().get(transformTask.getExecutorNode()).getVersion().onOrAfter(Version.V_7_8_0)) {
                ActionListener taskUpdateListener = ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                    if (e instanceof TransformTaskDisappearedDuringUpdateException) {
                        logger.debug("[{}] transform task disappeared during update, ignoring", (Object)request.getId());
                        listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
                        return;
                    }
                    if (e instanceof TransformTaskUpdateException) {
                        logger.warn((Message)new ParameterizedMessage("[{}] failed to notify running transform task about update. New settings will be applied after next checkpoint.", (Object)request.getId()), (Throwable)e);
                        listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
                        return;
                    }
                    listener.onFailure(e);
                });
                request.setNodes(new String[]{transformTask.getExecutorNode()});
                request.setConfig(updatedConfig);
                super.doExecute(task, (BaseTasksRequest)request, taskUpdateListener);
                return;
            }
            listener.onResponse((Object)new UpdateTransformAction.Response(updatedConfig));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkTransformConfigAndLogWarnings(TransformConfig config) {
        Function function = FunctionFactory.create(config);
        List<String> warnings = TransformConfigLinter.getWarnings(function, config.getSource(), config.getSyncConfig());
        for (String warning : warnings) {
            logger.warn((Message)new ParameterizedMessage("[{}] {}", (Object)config.getId(), (Object)warning));
            this.auditor.warning(config.getId(), warning);
        }
    }

    protected void taskOperation(UpdateTransformAction.Request request, TransformTask transformTask, ActionListener<UpdateTransformAction.Response> listener) {
        transformTask.applyNewSettings(request.getConfig().getSettings());
        listener.onResponse((Object)new UpdateTransformAction.Response(request.getConfig()));
    }

    protected UpdateTransformAction.Response newResponse(UpdateTransformAction.Request request, List<UpdateTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (tasks.isEmpty()) {
            if (!taskOperationFailures.isEmpty()) {
                throw new TransformTaskUpdateException("Failed to update running transform task.", taskOperationFailures.get(0).getCause(), new Object[0]);
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw new TransformTaskUpdateException("Failed to update running transform task.", (Throwable)failedNodeExceptions.get(0), new Object[0]);
            }
            throw new TransformTaskDisappearedDuringUpdateException("Could not update running transform as it has been stopped.");
        }
        return tasks.get(0);
    }

    private static class TransformTaskUpdateException
    extends ElasticsearchException {
        TransformTaskUpdateException(String msg, Throwable cause, Object ... args) {
            super(msg, cause, args);
        }
    }

    private static class TransformTaskDisappearedDuringUpdateException
    extends ElasticsearchException {
        TransformTaskDisappearedDuringUpdateException(String msg) {
            super(msg, new Object[0]);
        }
    }
}

