/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.authn;

import java.time.Clock;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;

public class FailedAuthenticationResponseMessageBuilder {
    private final Clock clock;
    private final SamlFactory samlFactory;
    private final SamlIdentityProvider idp;
    private String primaryStatusCode;
    private String statusMessage;
    private String acsUrl;
    private String inResponseTo;
    private String secondaryStatusCode;

    public FailedAuthenticationResponseMessageBuilder(SamlFactory samlFactory, Clock clock, SamlIdentityProvider idp) {
        SamlInit.initialize();
        this.samlFactory = samlFactory;
        this.clock = clock;
        this.idp = idp;
        this.primaryStatusCode = "urn:oasis:names:tc:SAML:2.0:status:Requester";
    }

    public FailedAuthenticationResponseMessageBuilder setAcsUrl(String acsUrl) {
        this.acsUrl = acsUrl;
        return this;
    }

    public FailedAuthenticationResponseMessageBuilder setPrimaryStatusCode(String primaryStatusCode) {
        this.primaryStatusCode = primaryStatusCode;
        return this;
    }

    public FailedAuthenticationResponseMessageBuilder setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public FailedAuthenticationResponseMessageBuilder setSecondaryStatusCode(String secondaryStatusCode) {
        this.secondaryStatusCode = secondaryStatusCode;
        return this;
    }

    public FailedAuthenticationResponseMessageBuilder setInResponseTo(String inResponseTo) {
        this.inResponseTo = inResponseTo;
        return this;
    }

    public Response build() {
        DateTime now = this.now();
        Response response = this.samlFactory.object(Response.class, Response.DEFAULT_ELEMENT_NAME);
        response.setID(this.samlFactory.secureIdentifier());
        response.setInResponseTo(this.inResponseTo);
        response.setIssuer(this.buildIssuer());
        response.setIssueInstant(now);
        response.setStatus(this.buildStatus());
        response.setDestination(this.acsUrl);
        return response;
    }

    private Issuer buildIssuer() {
        Issuer issuer = this.samlFactory.object(Issuer.class, Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.idp.getEntityId());
        return issuer;
    }

    private Status buildStatus() {
        StatusCode firstLevelCode = this.samlFactory.object(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
        firstLevelCode.setValue(this.primaryStatusCode);
        if (Strings.hasText((String)this.secondaryStatusCode)) {
            StatusCode secondLevelCode = this.samlFactory.object(StatusCode.class, StatusCode.DEFAULT_ELEMENT_NAME);
            secondLevelCode.setValue(this.secondaryStatusCode);
            firstLevelCode.setStatusCode(secondLevelCode);
        }
        Status status = this.samlFactory.object(Status.class, Status.DEFAULT_ELEMENT_NAME);
        if (Strings.hasText((String)this.statusMessage)) {
            StatusMessage firstLevelMessage = this.samlFactory.object(StatusMessage.class, StatusMessage.DEFAULT_ELEMENT_NAME);
            firstLevelMessage.setMessage(this.statusMessage);
            status.setStatusMessage(firstLevelMessage);
        }
        status.setStatusCode(firstLevelCode);
        return status;
    }

    private DateTime now() {
        return new DateTime(this.clock.millis(), DateTimeZone.UTC);
    }
}

