/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.ssl.X509KeyPairSettings;
import org.elasticsearch.xpack.idp.action.DeleteSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.action.PutSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.action.SamlInitiateSingleSignOnAction;
import org.elasticsearch.xpack.idp.action.SamlMetadataAction;
import org.elasticsearch.xpack.idp.action.SamlValidateAuthnRequestAction;
import org.elasticsearch.xpack.idp.action.TransportDeleteSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.action.TransportPutSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.action.TransportSamlInitiateSingleSignOnAction;
import org.elasticsearch.xpack.idp.action.TransportSamlMetadataAction;
import org.elasticsearch.xpack.idp.action.TransportSamlValidateAuthnRequestAction;
import org.elasticsearch.xpack.idp.privileges.ApplicationActionsResolver;
import org.elasticsearch.xpack.idp.privileges.UserPrivilegeResolver;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProvider;
import org.elasticsearch.xpack.idp.saml.idp.SamlIdentityProviderBuilder;
import org.elasticsearch.xpack.idp.saml.rest.action.IdpBaseRestHandler;
import org.elasticsearch.xpack.idp.saml.rest.action.RestDeleteSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.saml.rest.action.RestPutSamlServiceProviderAction;
import org.elasticsearch.xpack.idp.saml.rest.action.RestSamlInitiateSingleSignOnAction;
import org.elasticsearch.xpack.idp.saml.rest.action.RestSamlMetadataAction;
import org.elasticsearch.xpack.idp.saml.rest.action.RestSamlValidateAuthenticationRequestAction;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderFactory;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderIndex;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderResolver;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderCacheSettings;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderDefaults;
import org.elasticsearch.xpack.idp.saml.sp.WildcardServiceProviderResolver;
import org.elasticsearch.xpack.idp.saml.support.SamlFactory;
import org.elasticsearch.xpack.idp.saml.support.SamlInit;

public class IdentityProviderPlugin
extends Plugin
implements ActionPlugin {
    private static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting((String)"xpack.idp.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Logger logger = LogManager.getLogger();
    private boolean enabled;
    private Settings settings;

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.settings = environment.settings();
        this.enabled = (Boolean)ENABLED_SETTING.get(this.settings);
        if (!this.enabled) {
            return Collections.emptyList();
        }
        SamlInit.initialize();
        SamlServiceProviderIndex index = new SamlServiceProviderIndex(client, clusterService);
        SecurityContext securityContext = new SecurityContext(this.settings, threadPool.getThreadContext());
        ServiceProviderDefaults serviceProviderDefaults = ServiceProviderDefaults.forSettings(this.settings);
        ApplicationActionsResolver actionsResolver = new ApplicationActionsResolver(this.settings, serviceProviderDefaults, client);
        UserPrivilegeResolver userPrivilegeResolver = new UserPrivilegeResolver(client, securityContext, actionsResolver);
        SamlServiceProviderFactory serviceProviderFactory = new SamlServiceProviderFactory(serviceProviderDefaults);
        SamlServiceProviderResolver registeredServiceProviderResolver = new SamlServiceProviderResolver(this.settings, index, serviceProviderFactory);
        WildcardServiceProviderResolver wildcardServiceProviderResolver = WildcardServiceProviderResolver.create(environment, resourceWatcherService, scriptService, serviceProviderFactory);
        SamlIdentityProvider idp = SamlIdentityProvider.builder(registeredServiceProviderResolver, wildcardServiceProviderResolver).fromSettings(environment).serviceProviderDefaults(serviceProviderDefaults).build();
        SamlFactory factory = new SamlFactory();
        return Collections.unmodifiableList(Arrays.asList(index, idp, factory, userPrivilegeResolver));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(new ActionPlugin.ActionHandler((ActionType)SamlInitiateSingleSignOnAction.INSTANCE, TransportSamlInitiateSingleSignOnAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlValidateAuthnRequestAction.INSTANCE, TransportSamlValidateAuthnRequestAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SamlMetadataAction.INSTANCE, TransportSamlMetadataAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutSamlServiceProviderAction.INSTANCE, TransportPutSamlServiceProviderAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteSamlServiceProviderAction.INSTANCE, TransportDeleteSamlServiceProviderAction.class, new Class[0])));
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(new IdpBaseRestHandler[]{new RestSamlInitiateSingleSignOnAction(this.getLicenseState()), new RestSamlValidateAuthenticationRequestAction(this.getLicenseState()), new RestSamlMetadataAction(this.getLicenseState()), new RestPutSamlServiceProviderAction(this.getLicenseState()), new RestDeleteSamlServiceProviderAction(this.getLicenseState())}));
    }

    public List<Setting<?>> getSettings() {
        ArrayList<Object> settingList = new ArrayList<Object>();
        settingList.add(ENABLED_SETTING);
        settingList.addAll(SamlIdentityProviderBuilder.getSettings());
        settingList.addAll(ServiceProviderCacheSettings.getSettings());
        settingList.addAll(ServiceProviderDefaults.getSettings());
        settingList.addAll(WildcardServiceProviderResolver.getSettings());
        settingList.addAll(ApplicationActionsResolver.getSettings());
        settingList.addAll(X509KeyPairSettings.withPrefix((String)"xpack.idp.signing.", (boolean)false).getAllSettings());
        settingList.addAll(X509KeyPairSettings.withPrefix((String)"xpack.idp.metadata_signing.", (boolean)false).getAllSettings());
        return Collections.unmodifiableList(settingList);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }
}

