/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.util.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.config.PerPartitionCategorizationConfig;

public final class UpdateProcessMessage {
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final PerPartitionCategorizationConfig perPartitionCategorizationConfig;
    @Nullable
    private final List<JobUpdate.DetectorUpdate> detectorUpdates;
    @Nullable
    private final List<MlFilter> filters;
    @Nullable
    private final List<ScheduledEvent> scheduledEvents;

    private UpdateProcessMessage(@Nullable ModelPlotConfig modelPlotConfig, @Nullable PerPartitionCategorizationConfig perPartitionCategorizationConfig, @Nullable List<JobUpdate.DetectorUpdate> detectorUpdates, @Nullable List<MlFilter> filters, List<ScheduledEvent> scheduledEvents) {
        this.modelPlotConfig = modelPlotConfig;
        this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
        this.detectorUpdates = detectorUpdates;
        this.filters = filters;
        this.scheduledEvents = scheduledEvents;
    }

    @Nullable
    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public PerPartitionCategorizationConfig getPerPartitionCategorizationConfig() {
        return this.perPartitionCategorizationConfig;
    }

    @Nullable
    public List<JobUpdate.DetectorUpdate> getDetectorUpdates() {
        return this.detectorUpdates;
    }

    @Nullable
    public List<MlFilter> getFilters() {
        return this.filters;
    }

    @Nullable
    public List<ScheduledEvent> getScheduledEvents() {
        return this.scheduledEvents;
    }

    public static class Builder {
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private PerPartitionCategorizationConfig perPartitionCategorizationConfig;
        @Nullable
        private List<JobUpdate.DetectorUpdate> detectorUpdates;
        @Nullable
        private List<MlFilter> filters;
        @Nullable
        private List<ScheduledEvent> scheduledEvents;

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setPerPartitionCategorizationConfig(PerPartitionCategorizationConfig perPartitionCategorizationConfig) {
            this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
            return this;
        }

        public Builder setDetectorUpdates(List<JobUpdate.DetectorUpdate> detectorUpdates) {
            this.detectorUpdates = detectorUpdates;
            return this;
        }

        public Builder setFilters(List<MlFilter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder setScheduledEvents(List<ScheduledEvent> scheduledEvents) {
            this.scheduledEvents = scheduledEvents;
            return this;
        }

        public UpdateProcessMessage build() {
            return new UpdateProcessMessage(this.modelPlotConfig, this.perPartitionCategorizationConfig, this.detectorUpdates, this.filters, this.scheduledEvents);
        }
    }
}

