/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;

public class ProcessedField {
    private final PreProcessor preProcessor;

    public ProcessedField(PreProcessor processor) {
        this.preProcessor = Objects.requireNonNull(processor);
    }

    public List<String> getInputFieldNames() {
        return this.preProcessor.inputFields();
    }

    public List<String> getOutputFieldNames() {
        return this.preProcessor.outputFields();
    }

    public Set<String> getOutputFieldType(String outputField) {
        return Collections.singleton(this.preProcessor.getOutputFieldType(outputField));
    }

    public Object[] value(SearchHit hit, Function<String, ExtractedField> fieldExtractor) {
        List<String> inputFields = this.getInputFieldNames();
        HashMap<String, Object> inputs = new HashMap<String, Object>(inputFields.size(), 1.0f);
        for (String field : inputFields) {
            ExtractedField extractedField = fieldExtractor.apply(field);
            if (extractedField == null) {
                return new Object[0];
            }
            Object[] values = extractedField.value(hit);
            if (values == null || values.length == 0) continue;
            Object value = values[0];
            if (values.length != 1 || !DataFrameDataExtractor.isValidValue(value)) continue;
            inputs.put(field, value);
        }
        this.preProcessor.process(inputs);
        return this.preProcessor.outputFields().stream().map(inputs::get).toArray();
    }

    public String getProcessorName() {
        return this.preProcessor.getName();
    }
}

